/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.RetargetAction;

import de.bsvrz.buv.plugin.darstellung.internal.DarstellungMessages;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungIcons;

/**
 * Factory für die {@link RetargetAction}s des Plug-ins. Die hier erzeugten
 * Actions tun nichts, sie agieren nur als Platzhalter. Der Workbench Part muss
 * eine Action bereitstellen mit der selben ID, die die tatsächliche Aktion
 * ausführt. Im Workbench Part muss diese Action mit
 * {@link IActionBars#setGlobalActionHandler(String, IAction)} bekannt gemacht
 * werden.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 */
public abstract class DarstellungActionFactory {

	/**
	 * Schaltet auf das Tool zum Verschieben des aktuellen Ausschnitt um.
	 */
	public static final DarstellungActionFactory TOGGLE_EBENEN = new DarstellungActionFactory(
			"de.bsvrz.buv.plugin.darstellung.command.toggleEbene") {

		@Override
		public RetargetAction create() {
			final RetargetAction action = new RetargetAction(getCommandId(), DarstellungMessages.ToggleEbenen_Label,
					IAction.AS_CHECK_BOX);
			action.setToolTipText(DarstellungMessages.ToggleEbenen_Tooltip);
			action.setImageDescriptor(DarstellungIcons.ActionToggleEbenen.getImageDescriptor());
			action.setActionDefinitionId(getCommandId());
			return action;
		}
	};

	/**
	 * Schaltet auf das Tool zum Verschieben des aktuellen Ausschnitt um.
	 */
	public static final DarstellungActionFactory TOGGLE_OVERVIEW = new DarstellungActionFactory(
			"de.bsvrz.buv.plugin.darstellung.command.toggleOverview") {

		@Override
		public RetargetAction create() {
			final RetargetAction action = new RetargetAction(getCommandId(), DarstellungMessages.ToggleOverview_Label,
					IAction.AS_CHECK_BOX);
			action.setToolTipText(DarstellungMessages.ToggleOverview_Tooltip);
			action.setImageDescriptor(DarstellungIcons.ActionToggleOverview.getImageDescriptor());
			action.setActionDefinitionId(getCommandId());
			return action;
		}
	};

	/**
	 * Schaltet auf das Tool zum Verschieben des aktuellen Ausschnitt um.
	 */
	public static final DarstellungActionFactory TOGGLE_SYNCHRONIZE_SELECTION = new DarstellungActionFactory(
			"de.bsvrz.buv.plugin.darstellung.command.toggleSynchronizeSelection") {

		@Override
		public RetargetAction create() {
			final RetargetAction action = new RetargetAction(getCommandId(),
					DarstellungMessages.ToggleSynchronizeSelection_Label, IAction.AS_CHECK_BOX);
			action.setToolTipText(DarstellungMessages.ToggleSynchronizeSelection_Tooltip);
			action.setImageDescriptor(DarstellungIcons.ActionSelectionLink.getImageDescriptor());
			action.setActionDefinitionId(getCommandId());
			return action;
		}
	};

	/**
	 * Erzeugt eine Action die die Auswahl des anzuzeigenden gespeicherten
	 * Ausschnitts einer Ansicht ermöglicht.
	 */
	public static final DarstellungActionFactory SELECT_AUSSCHNITT = new DarstellungActionFactory(
			"de.bsvrz.buv.plugin.darstellung.command.selectAusschnitt") {

		@Override
		public RetargetAction create() {
			final RetargetAction action = new RetargetAction(getCommandId(), DarstellungMessages.SelectAusschnitt_Label,
					IAction.AS_DROP_DOWN_MENU) {

				@Override
				public IMenuCreator getMenuCreator() {
					final IAction actionHandler = getActionHandler();
					if (actionHandler instanceof IMenuCreator) {
						return (IMenuCreator) actionHandler;
					}
					return super.getMenuCreator();
				}

			};
			action.setToolTipText(DarstellungMessages.SelectAusschnitt_Tooltip);
			action.setImageDescriptor(DarstellungIcons.ActionSelectAusschnitt.getImageDescriptor());
			action.setActionDefinitionId(getCommandId());
			return action;
		}
	};

	private final String commandId;

	private DarstellungActionFactory(final String commandId) {
		this.commandId = commandId;
	}

	/**
	 * Erzeugt eine neue {@link RetargetAction}.
	 */
	public abstract RetargetAction create();

	/**
	 * Gibt die (Command-)ID der {@link RetargetAction} zurück.
	 */
	public String getCommandId() {
		return commandId;
	}

}
