/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.actions;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import de.bsvrz.buv.plugin.dobj.internal.DObjPlugin;
import de.bsvrz.buv.plugin.dobj.util.IDavZeitStempelManager;
import de.bsvrz.dav.daf.main.config.SystemObject;

/**
 * Ein Status-Item welches den letzten empfangenen Datenzeitstempel anzeigt.
 *
 * @author BitCtrl Systems GmbH, bitcontrol
 */
public class LetzterEmpfangenerDavZeitStempelStatus extends DarstellungStatus implements IDavZeitStempelManager {

	private static final SimpleDateFormat FORMAT = new SimpleDateFormat("HH:mm:ss");

	private long letzterEmpfangenerZeitStempel = -1;

	/**
	 * Initialisiert das Status Item.
	 *
	 * @param page
	 *            die Workbench Page fuer den das Item bestimmt ist.
	 */
	public LetzterEmpfangenerDavZeitStempelStatus(final IWorkbenchPage page) {
		super(page, LetzterEmpfangenerDavZeitStempelStatus.class.toString(), 10);
	}

	@Override
	public void setLetztenEmpfangenenZeitStempel(final long zeitStempel, final SystemObject obj) {
		if (zeitStempel == -1) {
			final StringWriter sw = new StringWriter();
			final PrintWriter pw = new PrintWriter(sw, true);
			new Exception().printStackTrace(pw);
			pw.flush();
			sw.flush();
			final String errorStackTrace = sw.toString();
			PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable() {

				@Override
				public void run() {
					setText("Err: Log!");
					DObjPlugin.getDefault().getLogger()
							.error("Zeitstempelproblem1 in " + obj + ":\n" + errorStackTrace);
				}

			});
		}
		if (zeitStempel > letzterEmpfangenerZeitStempel) {
			letzterEmpfangenerZeitStempel = zeitStempel;
			PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable() {

				@Override
				public void run() {
					setText(FORMAT.format(new Date(zeitStempel)));
				}

			});
		}
	}

	@Override
	protected void activate() {
		if (getViewer().getProperty(IDavZeitStempelManager.class.toString()) == null) {
			getViewer().setProperty(IDavZeitStempelManager.class.toString(), this);
		}
	}

	@Override
	protected void deactivate() {
		//
	}

}
