/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IWorkbenchPage;

import com.bitctrl.lib.eclipse.emf.util.EmfUtil;

import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.dav.daf.main.config.SystemObject;

/**
 * Ein Status Item welche das Objekt der Primary Selection anzeigt. Gibt es
 * keine Primary Selection wird falls vorhanden das erste Element der Selektion
 * angezeigt.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class SelectionStatus extends DarstellungStatus implements ISelectionChangedListener {

	/**
	 * Initialisiert das Status Item.
	 *
	 * @param page
	 *            die Workbench Page für den das Item bestimmt ist.
	 */
	public SelectionStatus(final IWorkbenchPage page) {
		super(page, SelectionStatus.class.toString(), 50);
	}

	@Override
	protected void activate() {
		getViewer().addSelectionChangedListener(this);
	}

	@Override
	protected void deactivate() {
		getViewer().removeSelectionChangedListener(this);
	}

	@Override
	public void selectionChanged(final SelectionChangedEvent event) {
		final ISelection selection = event.getSelection();
		if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
			setText("Kein Objekt ausgewählt");
			return;
		}

		final Object model = getPrimarySelectionOrFirstElement((IStructuredSelection) selection);
		if (model instanceof DoModel) {
			setText(getSystemObjektBezeichnerOderDarstellungsObjektName((DoModel) model));
		} else {
			setText(getText(model));
		}
	}

	private static Object getPrimarySelectionOrFirstElement(final IStructuredSelection selection) {
		for (final Object e : selection.toList()) {
			final EditPart editPart = (EditPart) e;
			if (editPart.getSelected() == EditPart.SELECTED_PRIMARY) {
				return editPart.getModel();
			}
		}

		final EditPart firstElement = (EditPart) selection.getFirstElement();
		return firstElement.getModel();
	}

	private static String getSystemObjektBezeichnerOderDarstellungsObjektName(final DoModel model) {
		final SystemObject so = model.getSystemObject();
		final String name = model.getName();
		if (so != null) {
			if (so.getName() != null) {
				return so.getName();
			}
			return so.getPid();
		} else if (name != null && !name.isEmpty()) {
			return name;
		}

		return EmfUtil.getText(model);
	}

	private static String getText(final Object model) {
		if (model instanceof EObject) {
			return EmfUtil.getText((EObject) model);
		}

		return model.toString();
	}

}
