/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.commands;

import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.commands.Command;

import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;

/**
 * Legt eine neue Ebene in einer Darstellung an. Die erste Ebene heißt einfach
 * "Ebene" jede weitere wird durchnummeriert.
 *
 * <p>
 * Eine Darstellung muss mindestens eine Ebene besitze, also kann eine Ebene nur
 * gelöscht werden, wenn es noch mindestens eine andere gibt.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class CreateEbeneCommand extends Command {

	private final Darstellung darstellung;
	private Ebene ebene;

	public CreateEbeneCommand(final Darstellung darstellung) {
		Assert.isNotNull(darstellung, "darstellung");

		this.darstellung = darstellung;

		setLabel("Neue Ebene anlegen");
	}

	@Override
	public void execute() {
		ebene = createEbene();
		redo();
	}

	private Ebene createEbene() {
		final Ebene e = darstellung.createEbene();
		String name = "Ebene";
		if (!darstellung.getEbenen().isEmpty()) {
			name = (darstellung.getEbenen().size() + 1) + ". " + name;
		}
		e.setName(name);
		return e;
	}

	@Override
	public void redo() {
		darstellung.getEbenen().add(ebene);
	}

	@Override
	public boolean canUndo() {
		return darstellung.getEbenen().size() > 1;
	}

	@Override
	public void undo() {
		darstellung.getEbenen().remove(ebene);
	}

}
