/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.commands;

import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;

import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.dobj.model.DoModel;

/**
 * Verschiebt ein Darstellungsobjekt in seiner Ebene oder Darstellungsspalte.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class MoveDoModelCommand extends Command {

	private final DoModel model;
	private final Point location;
	private Point oldLocation;

	public MoveDoModelCommand(final DoModel model, final Point location) {
		Assert.isNotNull(model, "model");
		Assert.isNotNull(location, "location");

		this.model = model;
		this.location = location;

		setLabel("Darstellungsobjekt verschieben");
	}

	@Override
	public boolean canExecute() {
		return model.eContainer() instanceof Ebene;
	}

	@Override
	public void execute() {
		Assert.isTrue(canExecute(), "command is not executable");

		oldLocation = model.getLocation();

		redo();
	}

	@Override
	public void redo() {
		final Point newLocation;
		if (isRelativPositioniert()) {
			newLocation = getRelativeLocation();
		} else {
			newLocation = getAbsoluteLocation();
		}
		model.setLocation(newLocation);
	}

	private boolean isRelativPositioniert() {
		return model.getRelativZu() != null;
	}

	private Point getRelativeLocation() {
		return getAbsoluteLocation().getCopy().translate(model.getRelativZu().getAbsoluteLocation().getNegated());
	}

	private Point getAbsoluteLocation() {
		return location;
	}

	@Override
	public void undo() {
		model.setLocation(oldLocation);
	}

}
