/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.commands;

import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.commands.Command;

import com.bitctrl.lib.eclipse.emf.gef.model.Sized;

import de.bsvrz.buv.plugin.dobj.model.DoModel;

/**
 * Kommando zum Ändern der Größe eines Darstellungsobjekts.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class ResizeDoModelCommand extends Command {

	private final Sized model;
	private final Dimension size;
	private Dimension oldSize;

	public ResizeDoModelCommand(final DoModel model, final Dimension size) {
		Assert.isNotNull(model, "model");
		Assert.isLegal(model instanceof Sized, "model muss Sized implementieren");
		Assert.isNotNull(size, "size");

		this.model = (Sized) model;
		this.size = size;

		setLabel("Darstellungsobjekt verschieben");
	}

	@Override
	public void execute() {
		oldSize = model.getSize();

		redo();
	}

	@Override
	public void redo() {
		model.setSize(size);
	}

	@Override
	public void undo() {
		model.setSize(oldSize);
	}

}
