/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.dialogs;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.ui.PlatformUI;

import de.bsvrz.buv.plugin.darstellung.model.Ansicht;
import de.bsvrz.buv.plugin.darstellung.model.Ausschnitt;

public class AusschnittAnlegenDialog extends InputDialog {

	private static final String ERROR_TEXT_LEER = "Der Name für den Ausschnitt darf nicht leer sein";
	private static final String WARNUNG_TEXT_OVERWRITE = "Der Ausschnit existiert bereits und wird überschrieben!";

	public AusschnittAnlegenDialog(final Ansicht ansicht) {
		super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Ausschnitt speichern",
				"Geben Sie einen Namen für den zu speichernden Ausschnitt an!", "", new IInputValidator() {

					@Override
					public String isValid(final String newText) {
						String result = null;
						final String newName = newText.trim();

						if (newName.isEmpty()) {
							result = ERROR_TEXT_LEER;
						} else if (ansicht != null) {
							for (final Ausschnitt ausschnitt : ansicht.getAusschnitte()) {
								if (ausschnitt.getName().equals(newName)) {
									result = WARNUNG_TEXT_OVERWRITE;
								}
							}
						}

						return result;
					}
				});
	}

	@Override
	public void setErrorMessage(final String errorMessage) {
		super.setErrorMessage(errorMessage);
		if (WARNUNG_TEXT_OVERWRITE.equals(errorMessage)) {
			getOkButton().setEnabled(true);
		}
	}
}
