/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.dialogs;

import org.eclipse.gef.dnd.SimpleObjectTransfer;
import org.eclipse.jface.viewers.StructuredViewer;

/**
 * Drag'n'Drop Transfer für beliebige Objekte. Da die Objekte nicht
 * (de-)serialisiert werden, funktioniert der Drag'n'Drop nur innerhalb einer
 * Instanz einer Eclipse-Applikation.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public final class ViewerTransfer extends SimpleObjectTransfer {

	private static final ViewerTransfer INSTANCE = new ViewerTransfer();
	private static final String TYPE_NAME = "Local Transfer"//$NON-NLS-1$
			+ System.currentTimeMillis() + ":" + INSTANCE.hashCode();//$NON-NLS-1$
	private static final int TYPEID = registerType(TYPE_NAME);

	private static StructuredViewer viewer;

	/**
	 * Returns the singleton instance.
	 *
	 * @return The singleton instance
	 */
	public static ViewerTransfer getInstance() {
		return INSTANCE;
	}

	private ViewerTransfer() {
		// hide constructor
	}

	/**
	 * @see org.eclipse.swt.dnd.Transfer#getTypeIds()
	 */
	@Override
	protected int[] getTypeIds() {
		return new int[] { TYPEID };
	}

	/**
	 * @see org.eclipse.swt.dnd.Transfer#getTypeNames()
	 */
	@Override
	protected String[] getTypeNames() {
		return new String[] { TYPE_NAME };
	}

	/**
	 * Returns the viewer where the drag started.
	 *
	 * @return The viewer where the drag started
	 */
	public StructuredViewer getViewer() {
		return viewer;
	}

	/**
	 * Sets the viewer where the drag started.
	 *
	 * @param viewer
	 *            The viewer
	 */
	public void setViewer(final StructuredViewer viewer) {
		ViewerTransfer.viewer = viewer;
	}

}
