/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.editparts;

import org.eclipse.gef.EditPart;

import de.bsvrz.buv.plugin.darstellung.model.Ansicht;
import de.bsvrz.buv.plugin.darstellung.model.AutoEbene;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung;
import de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung;
import de.bsvrz.buv.plugin.dobj.editparts.DoEditPartFactory;

/**
 * Erweitert die Factory aus dem Plug-in <em>Darstellungsobjekte</em> um die
 * Objekte aus dem Plug-in <em>Darstellung</em>.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class DarstellungEditPartFactory extends DoEditPartFactory {

	@Override
	protected EditPart doCreateEditPart(final EditPart context, final Object model) {
		if (model instanceof Ansicht) {
			return new AnsichtEditPart();
		} else if (model instanceof MassstaeblicheDarstellung) {
			return new MassstaeblicheDarstellungEditPart();
		} else if (model instanceof StilisierteDarstellung) {
			return new StilisierteDarstellungEditPart();
		} else if (model instanceof AutoEbene) {
			return new AutoEbeneEditPart();
		} else if (model instanceof Ebene) {
			return new EbeneEditPart();
		} else if (model instanceof DarstellungsSpalte) {
			return new DarstellungsSpalteEditPart();
		}

		return super.doCreateEditPart(context, model);
	}

}
