/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.editparts;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPart;

import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;
import de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung;
import de.bsvrz.buv.plugin.darstellung.util.QuadratischePlattkarteProjektion;
import de.bsvrz.buv.plugin.dobj.kollision.KollisionsManager;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;
import de.bsvrz.buv.plugin.dobj.util.Projektion;

/**
 * Controller für die maßstäbliche Darstellung.
 *
 * <p>
 * Registriert als Viewer-Property eine Projektion, mit der die Weltkoordinaten
 * (WGS-84) in Modellkoordinaten (Pixel) und zurück umgerechnet werden können.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 */
public class MassstaeblicheDarstellungEditPart extends DarstellungEditPart<MassstaeblicheDarstellung> {

	private QuadratischePlattkarteProjektion projektion;

	@Override
	public void setParent(final EditPart parent) {
		super.setParent(parent);
		if (parent != null) {
			getViewer().setProperty(KollisionsManager.class.toString(), new KollisionsManager());
			updateProjektion();
		}
	}

	private void updateProjektion() {
		projektion = new QuadratischePlattkarteProjektion();
		projektion.setDarstellung(getModel());
		getViewer().setProperty(Projektion.class.toString(), projektion);

		final double nord = getModel().getMaximaleGeographischeBreite();
		final double sued = getModel().getMinimaleGeographischeBreite();
		final double west = getModel().getMinimaleGeographischeLaenge();
		final double ost = getModel().getMaximaleGeographischeLaenge();
		final Point obenLinks = projektion.umrechnenWeltNachModel(new PrecisionPoint(west, nord));
		final Point untenRechts = projektion.umrechnenWeltNachModel(new PrecisionPoint(ost, sued));
		getModel().setSize(new Dimension(untenRechts.x - obenLinks.x, untenRechts.y - obenLinks.y));
	}

	@Override
	public void notifyChanged(final Notification notification) {
		super.notifyChanged(notification);

		final Object notifier = notification.getNotifier();
		final int type = notification.getEventType();

		if (notifier instanceof MassstaeblicheDarstellung) {
			final int featureID = notification.getFeatureID(DobjPackage.class);
			switch (type) {
			case Notification.SET:
				switch (featureID) {
				case DarstellungPackage.MASSSTAEBLICHE_DARSTELLUNG__MAXIMALE_GEOGRAPHISCHE_BREITE:
				case DarstellungPackage.MASSSTAEBLICHE_DARSTELLUNG__MINIMALE_GEOGRAPHISCHE_BREITE:
				case DarstellungPackage.MASSSTAEBLICHE_DARSTELLUNG__MAXIMALE_GEOGRAPHISCHE_LAENGE:
				case DarstellungPackage.MASSSTAEBLICHE_DARSTELLUNG__MINIMALE_GEOGRAPHISCHE_LAENGE:
					updateProjektion();
					break;
				}
				break;
			}
		}
	}

}
