/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.editparts.tree;

import java.util.List;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import com.bitctrl.lib.eclipse.emf.gef.editparts.tree.AdapterTreeEditPart;

import de.bsvrz.buv.plugin.darstellung.editpolicies.DarstellungsSpalteEditPolicy;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungIcons;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;

/**
 * Tree Edit Part für eine Darstellungsspalte.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class DarstellungsSpalteTreeEditPart extends AdapterTreeEditPart<DarstellungsSpalte> {

	/*
	 * Diese zwei Images dürfen nicht disposed werden. Sie werden vom
	 * ResourceManager des Viewers disposed.
	 */
	private Image spalteVisible;
	private Image spalteInvisible;

	@Override
	protected List<DoModel> getModelChildren() {
		return getModel().getDoObjekte();
	}

	@Override
	protected Color getForeground() {
		if (!getModel().isVisible()) {
			return ColorConstants.gray;
		}
		return null;
	}

	@Override
	protected Image getImage() {
		if (spalteVisible == null) {
			spalteVisible = getViewer().getResourceManager()
					.createImage(DarstellungIcons.StatusEbeneVisible.getImageDescriptor());
			spalteInvisible = getViewer().getResourceManager()
					.createImage(DarstellungIcons.StatusEbeneInvisible.getImageDescriptor());
		}
		if (getModel().isVisible()) {
			return spalteVisible;
		}

		return spalteInvisible;
	}

	@Override
	public void notifyChanged(final Notification notification) {
		final int type = notification.getEventType();
		final int featureID = notification.getFeatureID(DobjPackage.class);

		switch (type) {
		case Notification.SET:
			switch (featureID) {
			case DarstellungPackage.DARSTELLUNGS_SPALTE__NAME:
			case DarstellungPackage.DARSTELLUNGS_SPALTE__VISIBLE:
			case DarstellungPackage.DARSTELLUNGS_SPALTE__WIDTH:
				refreshVisuals();
				break;
			}
			break;
		case Notification.ADD:
		case Notification.REMOVE:
		case Notification.MOVE:
			switch (featureID) {
			case DarstellungPackage.DARSTELLUNGS_SPALTE__DO_OBJEKTE:
				refreshChildren();
				break;
			}
			break;
		}
	}

	@Override
	public void activate() {
		super.activate();

		spalteVisible = DarstellungIcons.StatusEbeneVisible.getImageDescriptor().createImage();
		spalteInvisible = DarstellungIcons.StatusEbeneInvisible.getImageDescriptor().createImage();
	}

	@Override
	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.COMPONENT_ROLE, new DarstellungsSpalteEditPolicy());
	}

	@Override
	public DragTracker getDragTracker(final Request req) {
		return new SelectEditPartTracker(this);
	}

	@Override
	public void performRequest(final Request req) {
		if (req.getType().equals(RequestConstants.REQ_OPEN)) {
			final SetCommand cmd = new SetCommand(getModel(), DarstellungPackage.Literals.DARSTELLUNGS_SPALTE__VISIBLE,
					!getModel().isVisible());
			getViewer().getEditDomain().getCommandStack().execute(cmd);
		}

		super.performRequest(req);
	}

}
