/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.editparts.tree;

import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Image;

import de.bsvrz.buv.plugin.darstellung.util.DarstellungIcons;
import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.MutableSet;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;

/**
 * Tree Edit Part für ein Systemobjekt.
 *
 * <p>
 * Unterscheidet zwischen Systemobjekt, Konfigurationsbereich, dynamische Menge
 * und Systemobjekt allgemein.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann.
 *
 */
public class SystemObjectTreeEditPart extends AbstractTreeEditPart {

	@Override
	protected String getText() {
		return getModel().toString();
	}

	@Override
	protected Image getImage() {
		final SystemObject so = (SystemObject) getModel();

		if (so instanceof SystemObjectType) {
			return getResourceManager().createImage(DarstellungIcons.CategorySystemObjektTyp.getImageDescriptor());
		} else if (so instanceof ConfigurationArea) {
			return getResourceManager()
					.createImage(DarstellungIcons.CategoryKonfigurationsbereich.getImageDescriptor());
		} else if (so instanceof MutableSet) {
			return getResourceManager().createImage(DarstellungIcons.CategoryDynamischeMenge.getImageDescriptor());
		}

		return getResourceManager().createImage(DarstellungIcons.CategorySystemObjekt.getImageDescriptor());
	}

	private ResourceManager getResourceManager() {
		return getViewer().getResourceManager();
	}

}
