/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.editpolicies;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.GroupRequest;

import de.bsvrz.buv.plugin.darstellung.commands.DeleteDoModelCommand;
import de.bsvrz.buv.plugin.dobj.model.DoModel;

/**
 * Tree Edit Policy für ein Darstellungsobjekt {@link DoModel}.
 *
 * <p>
 * Kontrolliert das Bewegen des Darstellungsobjekt im Tree.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class DoModelTreeEditPolicy extends ComponentEditPolicy {

	@Override
	public Command getCommand(final Request req) {
		if (REQ_MOVE.equals(req.getType())) {
			return getMoveCommand((ChangeBoundsRequest) req);
		}

		return super.getCommand(req);
	}

	@Override
	protected Command createDeleteCommand(final GroupRequest deleteRequest) {
		final DoModel doModel = (DoModel) getHost().getModel();
		return new DeleteDoModelCommand(doModel);
	}

	/**
	 * Delegiert die Suche nach einem geeigneten Kommando an den Parent Edit
	 * Part.
	 */
	protected Command getMoveCommand(final ChangeBoundsRequest req) {
		final EditPart parent = getHost().getParent();
		if (parent != null) {
			final ChangeBoundsRequest request = new ChangeBoundsRequest(REQ_MOVE_CHILDREN);
			request.setEditParts(getHost());
			request.setLocation(req.getLocation());
			return parent.getCommand(request);
		}

		return UnexecutableCommand.INSTANCE;
	}

}
