/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.darstellung.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

import de.bsvrz.buv.plugin.darstellung.views.ansicht.AnsichtsView;
import de.bsvrz.buv.plugin.dobj.internal.DObjPlugin;

/**
 * Handler fuer das Kommando zum Oeffnen einer (parametrierten) Ansicht XY.
 *
 * @author BitCtrl Systems GmbH, Thomas Thierfelder
 */
public class OpenAnsichtXYHandler extends AbstractHandler {

	private final String parameterAnsichtNameId = OpenAnsichtXYHandler.class.getName() + ".ParameterAnsichtName";
	private final String parameterSpeicherOrt = OpenAnsichtXYHandler.class.getName() + ".ParameterAnsichtSpeicherOrt";
	private final String parameterAusschnitt = OpenAnsichtXYHandler.class.getName() + ".ParameterAnsichtAusschnitt";

	@Override
	public Object execute(final ExecutionEvent event) throws ExecutionException {

		final String ansichtName = (String) event.getObjectParameterForExecution(parameterAnsichtNameId);

		if (ansichtName.isEmpty()) {
			final String warnText = "Kommando kann nicht ausgeführt werden, weil kein Name für die zu öffnende Ansicht angegeben wurde!";
			final IStatus status = new Status(IStatus.ERROR, DObjPlugin.PLUGIN_ID, warnText);
			ErrorDialog.openError(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, null, status);
			throw new ExecutionException(warnText);
		}

		final String speicherOrtName = (String) event.getObjectParameterForExecution(parameterSpeicherOrt);
		final String ausschnitt = (String) event.getObjectParameterForExecution(parameterAusschnitt);
		try {

			final IWorkbenchWindow dw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
			IWorkbenchPage page = dw.getActivePage();
			if (page == null) {
				page = dw.openPage(null);
			}

			page.showView(AnsichtsView.VIEW_ID, speicherOrtName + "|" + ansichtName + "|" + ausschnitt,
					IWorkbenchPage.VIEW_ACTIVATE);

		} catch (final Exception ex) {
			final String warnText = "Ansicht " + ansichtName + " konnte nicht geöffnet werden!";
			final IStatus status = new Status(IStatus.WARNING, DObjPlugin.PLUGIN_ID, warnText, ex);
			ErrorDialog.openError(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, null, status);
			throw new ExecutionException(warnText, ex);
		}
		return null;
	}
}
