/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.internal;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

import de.bsvrz.buv.plugin.darstellung.actions.DarstellungActionConstants;
import de.bsvrz.buv.plugin.darstellung.actions.EditAnsichtenAction;
import de.bsvrz.buv.plugin.darstellung.actions.ZeigeAnsichtAction;

/**
 * Default Handler für die Commands dieses Plug-ins.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class DefaultCommandHandler extends AbstractHandler {

	@Override
	public Object execute(final ExecutionEvent event) throws ExecutionException {
		final Shell shell = HandlerUtil.getActiveShell(event);

		final String commandId = event.getCommand().getId();
		final IWorkbenchPart part = HandlerUtil.getActivePart(event);

		if (DarstellungActionConstants.ZEIGE_ANSICHT.equals(commandId)) {
			new ZeigeAnsichtAction(part).run();
		} else if (DarstellungActionConstants.EDIT_ANSICHTEN.equals(commandId)) {
			new EditAnsichtenAction(shell).run();
		}

		return null;
	}

}
