/**
 * Darstellungsobjekte
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.darstellung.model;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import com.bitctrl.lib.eclipse.emf.eclipse.model.EclipsePackage;

/**
 * <!-- begin-user-doc --> The <b>Package</b> for the model. It contains
 * accessors for the meta objects to represent
 * <ul>
 * <li>each class,</li>
 * <li>each feature of each class,</li>
 * <li>each enum,</li>
 * <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungFactory
 * @model kind="package"
 * @generated
 */
public interface DarstellungPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "darstellung";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://de.bsvrz.buv.plugin.darstellung/1.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "darstellung";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	DarstellungPackage eINSTANCE = de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungPackageImpl.init();

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungImpl
	 * <em>Darstellung</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungImpl
	 * @see de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungPackageImpl#getDarstellung()
	 * @generated
	 */
	int DARSTELLUNG = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DARSTELLUNG__NAME = EclipsePackage.NAMED__NAME;

	/**
	 * The feature id for the '<em><b>Size</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DARSTELLUNG__SIZE = EclipsePackage.NAMED_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Do Typen</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DARSTELLUNG__DO_TYPEN = EclipsePackage.NAMED_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Ebenen</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DARSTELLUNG__EBENEN = EclipsePackage.NAMED_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Netz</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DARSTELLUNG__NETZ = EclipsePackage.NAMED_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Zoom Skalierung</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DARSTELLUNG__ZOOM_SKALIERUNG = EclipsePackage.NAMED_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Zoom Stufen</b></em>' attribute list. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DARSTELLUNG__ZOOM_STUFEN = EclipsePackage.NAMED_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' map. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DARSTELLUNG__PROPERTIES = EclipsePackage.NAMED_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Verbindungslinie Farbe</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DARSTELLUNG__VERBINDUNGSLINIE_FARBE = EclipsePackage.NAMED_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Verbindungslinie Staerke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DARSTELLUNG__VERBINDUNGSLINIE_STAERKE = EclipsePackage.NAMED_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Verbindungslinie Stil</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DARSTELLUNG__VERBINDUNGSLINIE_STIL = EclipsePackage.NAMED_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Stoerfallverfahren</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DARSTELLUNG__STOERFALLVERFAHREN = EclipsePackage.NAMED_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Anzeige Verfahren</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DARSTELLUNG__ANZEIGE_VERFAHREN = EclipsePackage.NAMED_FEATURE_COUNT + 11;

	/**
	 * The number of structural features of the '<em>Darstellung</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DARSTELLUNG_FEATURE_COUNT = EclipsePackage.NAMED_FEATURE_COUNT + 12;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.darstellung.model.impl.AnsichtImpl <em>Ansicht</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.darstellung.model.impl.AnsichtImpl
	 * @see de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungPackageImpl#getAnsicht()
	 * @generated
	 */
	int ANSICHT = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ANSICHT__NAME = EclipsePackage.NAMED__NAME;

	/**
	 * The feature id for the '<em><b>Ausschnitt</b></em>' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANSICHT__AUSSCHNITT = EclipsePackage.NAMED_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Darstellung</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANSICHT__DARSTELLUNG = EclipsePackage.NAMED_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Ausschnitte</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANSICHT__AUSSCHNITTE = EclipsePackage.NAMED_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ansicht</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ANSICHT_FEATURE_COUNT = EclipsePackage.NAMED_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.darstellung.model.impl.StilisierteDarstellungImpl <em>Stilisierte Darstellung</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.bsvrz.buv.plugin.darstellung.model.impl.StilisierteDarstellungImpl
	 * @see de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungPackageImpl#getStilisierteDarstellung()
	 * @generated
	 */
	int STILISIERTE_DARSTELLUNG = 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STILISIERTE_DARSTELLUNG__NAME = DARSTELLUNG__NAME;

	/**
	 * The feature id for the '<em><b>Size</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STILISIERTE_DARSTELLUNG__SIZE = DARSTELLUNG__SIZE;

	/**
	 * The feature id for the '<em><b>Do Typen</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STILISIERTE_DARSTELLUNG__DO_TYPEN = DARSTELLUNG__DO_TYPEN;

	/**
	 * The feature id for the '<em><b>Ebenen</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STILISIERTE_DARSTELLUNG__EBENEN = DARSTELLUNG__EBENEN;

	/**
	 * The feature id for the '<em><b>Netz</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STILISIERTE_DARSTELLUNG__NETZ = DARSTELLUNG__NETZ;

	/**
	 * The feature id for the '<em><b>Zoom Skalierung</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STILISIERTE_DARSTELLUNG__ZOOM_SKALIERUNG = DARSTELLUNG__ZOOM_SKALIERUNG;

	/**
	 * The feature id for the '<em><b>Zoom Stufen</b></em>' attribute list. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STILISIERTE_DARSTELLUNG__ZOOM_STUFEN = DARSTELLUNG__ZOOM_STUFEN;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' map. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STILISIERTE_DARSTELLUNG__PROPERTIES = DARSTELLUNG__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Verbindungslinie Farbe</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STILISIERTE_DARSTELLUNG__VERBINDUNGSLINIE_FARBE = DARSTELLUNG__VERBINDUNGSLINIE_FARBE;

	/**
	 * The feature id for the '<em><b>Verbindungslinie Staerke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STILISIERTE_DARSTELLUNG__VERBINDUNGSLINIE_STAERKE = DARSTELLUNG__VERBINDUNGSLINIE_STAERKE;

	/**
	 * The feature id for the '<em><b>Verbindungslinie Stil</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STILISIERTE_DARSTELLUNG__VERBINDUNGSLINIE_STIL = DARSTELLUNG__VERBINDUNGSLINIE_STIL;

	/**
	 * The feature id for the '<em><b>Stoerfallverfahren</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STILISIERTE_DARSTELLUNG__STOERFALLVERFAHREN = DARSTELLUNG__STOERFALLVERFAHREN;

	/**
	 * The feature id for the '<em><b>Anzeige Verfahren</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STILISIERTE_DARSTELLUNG__ANZEIGE_VERFAHREN = DARSTELLUNG__ANZEIGE_VERFAHREN;

	/**
	 * The feature id for the '<em><b>Spalten</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STILISIERTE_DARSTELLUNG__SPALTEN = DARSTELLUNG_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Spalten Border</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STILISIERTE_DARSTELLUNG__SPALTEN_BORDER = DARSTELLUNG_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Stilisierte Darstellung</em>' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STILISIERTE_DARSTELLUNG_FEATURE_COUNT = DARSTELLUNG_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.darstellung.model.impl.MassstaeblicheDarstellungImpl <em>Massstaebliche Darstellung</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.bsvrz.buv.plugin.darstellung.model.impl.MassstaeblicheDarstellungImpl
	 * @see de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungPackageImpl#getMassstaeblicheDarstellung()
	 * @generated
	 */
	int MASSSTAEBLICHE_DARSTELLUNG = 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MASSSTAEBLICHE_DARSTELLUNG__NAME = DARSTELLUNG__NAME;

	/**
	 * The feature id for the '<em><b>Size</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MASSSTAEBLICHE_DARSTELLUNG__SIZE = DARSTELLUNG__SIZE;

	/**
	 * The feature id for the '<em><b>Do Typen</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MASSSTAEBLICHE_DARSTELLUNG__DO_TYPEN = DARSTELLUNG__DO_TYPEN;

	/**
	 * The feature id for the '<em><b>Ebenen</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MASSSTAEBLICHE_DARSTELLUNG__EBENEN = DARSTELLUNG__EBENEN;

	/**
	 * The feature id for the '<em><b>Netz</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MASSSTAEBLICHE_DARSTELLUNG__NETZ = DARSTELLUNG__NETZ;

	/**
	 * The feature id for the '<em><b>Zoom Skalierung</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MASSSTAEBLICHE_DARSTELLUNG__ZOOM_SKALIERUNG = DARSTELLUNG__ZOOM_SKALIERUNG;

	/**
	 * The feature id for the '<em><b>Zoom Stufen</b></em>' attribute list. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MASSSTAEBLICHE_DARSTELLUNG__ZOOM_STUFEN = DARSTELLUNG__ZOOM_STUFEN;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' map. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MASSSTAEBLICHE_DARSTELLUNG__PROPERTIES = DARSTELLUNG__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Verbindungslinie Farbe</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MASSSTAEBLICHE_DARSTELLUNG__VERBINDUNGSLINIE_FARBE = DARSTELLUNG__VERBINDUNGSLINIE_FARBE;

	/**
	 * The feature id for the '<em><b>Verbindungslinie Staerke</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MASSSTAEBLICHE_DARSTELLUNG__VERBINDUNGSLINIE_STAERKE = DARSTELLUNG__VERBINDUNGSLINIE_STAERKE;

	/**
	 * The feature id for the '<em><b>Verbindungslinie Stil</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MASSSTAEBLICHE_DARSTELLUNG__VERBINDUNGSLINIE_STIL = DARSTELLUNG__VERBINDUNGSLINIE_STIL;

	/**
	 * The feature id for the '<em><b>Stoerfallverfahren</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MASSSTAEBLICHE_DARSTELLUNG__STOERFALLVERFAHREN = DARSTELLUNG__STOERFALLVERFAHREN;

	/**
	 * The feature id for the '<em><b>Anzeige Verfahren</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MASSSTAEBLICHE_DARSTELLUNG__ANZEIGE_VERFAHREN = DARSTELLUNG__ANZEIGE_VERFAHREN;

	/**
	 * The feature id for the '<em><b>Maximale Geographische Breite</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MASSSTAEBLICHE_DARSTELLUNG__MAXIMALE_GEOGRAPHISCHE_BREITE = DARSTELLUNG_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Minimale Geographische Breite</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MASSSTAEBLICHE_DARSTELLUNG__MINIMALE_GEOGRAPHISCHE_BREITE = DARSTELLUNG_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Maximale Geographische Laenge</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MASSSTAEBLICHE_DARSTELLUNG__MAXIMALE_GEOGRAPHISCHE_LAENGE = DARSTELLUNG_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Minimale Geographische Laenge</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MASSSTAEBLICHE_DARSTELLUNG__MINIMALE_GEOGRAPHISCHE_LAENGE = DARSTELLUNG_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Massstaebliche Darstellung</em>' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MASSSTAEBLICHE_DARSTELLUNG_FEATURE_COUNT = DARSTELLUNG_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.darstellung.model.impl.EbeneImpl <em>Ebene</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.darstellung.model.impl.EbeneImpl
	 * @see de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungPackageImpl#getEbene()
	 * @generated
	 */
	int EBENE = 4;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EBENE__NAME = EclipsePackage.NAMED__NAME;

	/**
	 * The feature id for the '<em><b>Visible</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EBENE__VISIBLE = EclipsePackage.NAMED_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Darstellung</b></em>' container reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EBENE__DARSTELLUNG = EclipsePackage.NAMED_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Do Objekte</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EBENE__DO_OBJEKTE = EclipsePackage.NAMED_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Hintergrund</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EBENE__HINTERGRUND = EclipsePackage.NAMED_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Hintergrund Skalierung</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EBENE__HINTERGRUND_SKALIERUNG = EclipsePackage.NAMED_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Hintergrund Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EBENE__HINTERGRUND_LOCATION = EclipsePackage.NAMED_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Editable</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EBENE__EDITABLE = EclipsePackage.NAMED_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Ausblendbar</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EBENE__AUSBLENDBAR = EclipsePackage.NAMED_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>Ebene</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EBENE_FEATURE_COUNT = EclipsePackage.NAMED_FEATURE_COUNT + 8;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungsSpalteImpl <em>Darstellungs Spalte</em>}' class.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungsSpalteImpl
	 * @see de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungPackageImpl#getDarstellungsSpalte()
	 * @generated
	 */
	int DARSTELLUNGS_SPALTE = 5;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DARSTELLUNGS_SPALTE__NAME = EclipsePackage.NAMED__NAME;

	/**
	 * The feature id for the '<em><b>Visible</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DARSTELLUNGS_SPALTE__VISIBLE = EclipsePackage.NAMED_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DARSTELLUNGS_SPALTE__WIDTH = EclipsePackage.NAMED_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Do Objekte</b></em>' reference list. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DARSTELLUNGS_SPALTE__DO_OBJEKTE = EclipsePackage.NAMED_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Darstellung</b></em>' container reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DARSTELLUNGS_SPALTE__DARSTELLUNG = EclipsePackage.NAMED_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Darstellungs Spalte</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DARSTELLUNGS_SPALTE_FEATURE_COUNT = EclipsePackage.NAMED_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.darstellung.model.impl.AutoEbeneImpl
	 * <em>Auto Ebene</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.bsvrz.buv.plugin.darstellung.model.impl.AutoEbeneImpl
	 * @see de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungPackageImpl#getAutoEbene()
	 * @generated
	 */
	int AUTO_EBENE = 6;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int AUTO_EBENE__NAME = EBENE__NAME;

	/**
	 * The feature id for the '<em><b>Visible</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int AUTO_EBENE__VISIBLE = EBENE__VISIBLE;

	/**
	 * The feature id for the '<em><b>Darstellung</b></em>' container reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUTO_EBENE__DARSTELLUNG = EBENE__DARSTELLUNG;

	/**
	 * The feature id for the '<em><b>Do Objekte</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUTO_EBENE__DO_OBJEKTE = EBENE__DO_OBJEKTE;

	/**
	 * The feature id for the '<em><b>Hintergrund</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int AUTO_EBENE__HINTERGRUND = EBENE__HINTERGRUND;

	/**
	 * The feature id for the '<em><b>Hintergrund Skalierung</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUTO_EBENE__HINTERGRUND_SKALIERUNG = EBENE__HINTERGRUND_SKALIERUNG;

	/**
	 * The feature id for the '<em><b>Hintergrund Location</b></em>' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUTO_EBENE__HINTERGRUND_LOCATION = EBENE__HINTERGRUND_LOCATION;

	/**
	 * The feature id for the '<em><b>Editable</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int AUTO_EBENE__EDITABLE = EBENE__EDITABLE;

	/**
	 * The feature id for the '<em><b>Ausblendbar</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUTO_EBENE__AUSBLENDBAR = EBENE__AUSBLENDBAR;

	/**
	 * The feature id for the '<em><b>System Object Types</b></em>' attribute list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUTO_EBENE__SYSTEM_OBJECT_TYPES = EBENE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Configuration Areas</b></em>' attribute list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUTO_EBENE__CONFIGURATION_AREAS = EBENE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>System Objects</b></em>' attribute list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUTO_EBENE__SYSTEM_OBJECTS = EBENE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Mutable Sets</b></em>' attribute list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUTO_EBENE__MUTABLE_SETS = EBENE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Do Typen</b></em>' reference list. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int AUTO_EBENE__DO_TYPEN = EBENE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Auto Do Objekte</b></em>' reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUTO_EBENE__AUTO_DO_OBJEKTE = EBENE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>System Objects Excludes</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUTO_EBENE__SYSTEM_OBJECTS_EXCLUDES = EBENE_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Auto Ebene</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUTO_EBENE_FEATURE_COUNT = EBENE_FEATURE_COUNT + 7;

	/**
	 * The meta object id for the '
	 * {@link de.bsvrz.buv.plugin.darstellung.model.impl.AusschnittImpl
	 * <em>Ausschnitt</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see de.bsvrz.buv.plugin.darstellung.model.impl.AusschnittImpl
	 * @see de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungPackageImpl#getAusschnitt()
	 * @generated
	 */
	int AUSSCHNITT = 7;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int AUSSCHNITT__NAME = EclipsePackage.NAMED__NAME;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int AUSSCHNITT__BOUNDS = EclipsePackage.NAMED_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Zoom Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUSSCHNITT__ZOOM_LEVEL = EclipsePackage.NAMED_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ausschnitt</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUSSCHNITT_FEATURE_COUNT = EclipsePackage.NAMED_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.bsvrz.buv.plugin.darstellung.model.AnzeigeVerfahren <em>Anzeige Verfahren</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.bsvrz.buv.plugin.darstellung.model.AnzeigeVerfahren
	 * @see de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungPackageImpl#getAnzeigeVerfahren()
	 * @generated
	 */
	int ANZEIGE_VERFAHREN = 8;

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung <em>Darstellung</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Darstellung</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Darstellung
	 * @generated
	 */
	EClass getDarstellung();

	/**
	 * Returns the meta object for the containment reference list '{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getDoTypen <em>Do Typen</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Do Typen</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Darstellung#getDoTypen()
	 * @see #getDarstellung()
	 * @generated
	 */
	EReference getDarstellung_DoTypen();

	/**
	 * Returns the meta object for the containment reference list '{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getEbenen <em>Ebenen</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Ebenen</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Darstellung#getEbenen()
	 * @see #getDarstellung()
	 * @generated
	 */
	EReference getDarstellung_Ebenen();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getNetz <em>Netz</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Netz</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Darstellung#getNetz()
	 * @see #getDarstellung()
	 * @generated
	 */
	EAttribute getDarstellung_Netz();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getZoomSkalierung <em>Zoom Skalierung</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Zoom Skalierung</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Darstellung#getZoomSkalierung()
	 * @see #getDarstellung()
	 * @generated
	 */
	EAttribute getDarstellung_ZoomSkalierung();

	/**
	 * Returns the meta object for the attribute list '{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getZoomStufen <em>Zoom Stufen</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Zoom Stufen</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Darstellung#getZoomStufen()
	 * @see #getDarstellung()
	 * @generated
	 */
	EAttribute getDarstellung_ZoomStufen();

	/**
	 * Returns the meta object for the map '{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getProperties <em>Properties</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the map '<em>Properties</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Darstellung#getProperties()
	 * @see #getDarstellung()
	 * @generated
	 */
	EReference getDarstellung_Properties();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getVerbindungslinieFarbe <em>Verbindungslinie Farbe</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Verbindungslinie Farbe</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Darstellung#getVerbindungslinieFarbe()
	 * @see #getDarstellung()
	 * @generated
	 */
	EAttribute getDarstellung_VerbindungslinieFarbe();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getVerbindungslinieStaerke <em>Verbindungslinie Staerke</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Verbindungslinie Staerke</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Darstellung#getVerbindungslinieStaerke()
	 * @see #getDarstellung()
	 * @generated
	 */
	EAttribute getDarstellung_VerbindungslinieStaerke();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getVerbindungslinieStil <em>Verbindungslinie Stil</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Verbindungslinie Stil</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Darstellung#getVerbindungslinieStil()
	 * @see #getDarstellung()
	 * @generated
	 */
	EAttribute getDarstellung_VerbindungslinieStil();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getStoerfallverfahren <em>Stoerfallverfahren</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Stoerfallverfahren</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Darstellung#getStoerfallverfahren()
	 * @see #getDarstellung()
	 * @generated
	 */
	EAttribute getDarstellung_Stoerfallverfahren();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.darstellung.model.Darstellung#getAnzeigeVerfahren <em>Anzeige Verfahren</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Anzeige Verfahren</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Darstellung#getAnzeigeVerfahren()
	 * @see #getDarstellung()
	 * @generated
	 */
	EAttribute getDarstellung_AnzeigeVerfahren();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.darstellung.model.Ansicht <em>Ansicht</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Ansicht</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Ansicht
	 * @generated
	 */
	EClass getAnsicht();

	/**
	 * Returns the meta object for the reference '{@link de.bsvrz.buv.plugin.darstellung.model.Ansicht#getAusschnitt <em>Ausschnitt</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Ausschnitt</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Ansicht#getAusschnitt()
	 * @see #getAnsicht()
	 * @generated
	 */
	EReference getAnsicht_Ausschnitt();

	/**
	 * Returns the meta object for the containment reference '{@link de.bsvrz.buv.plugin.darstellung.model.Ansicht#getDarstellung <em>Darstellung</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Darstellung</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Ansicht#getDarstellung()
	 * @see #getAnsicht()
	 * @generated
	 */
	EReference getAnsicht_Darstellung();

	/**
	 * Returns the meta object for the containment reference list '{@link de.bsvrz.buv.plugin.darstellung.model.Ansicht#getAusschnitte <em>Ausschnitte</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Ausschnitte</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Ansicht#getAusschnitte()
	 * @see #getAnsicht()
	 * @generated
	 */
	EReference getAnsicht_Ausschnitte();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung <em>Stilisierte Darstellung</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for class '<em>Stilisierte Darstellung</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung
	 * @generated
	 */
	EClass getStilisierteDarstellung();

	/**
	 * Returns the meta object for the containment reference list '{@link de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung#getSpalten <em>Spalten</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Spalten</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung#getSpalten()
	 * @see #getStilisierteDarstellung()
	 * @generated
	 */
	EReference getStilisierteDarstellung_Spalten();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung#isSpaltenBorder <em>Spalten Border</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Spalten Border</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung#isSpaltenBorder()
	 * @see #getStilisierteDarstellung()
	 * @generated
	 */
	EAttribute getStilisierteDarstellung_SpaltenBorder();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung <em>Massstaebliche Darstellung</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for class '<em>Massstaebliche Darstellung</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung
	 * @generated
	 */
	EClass getMassstaeblicheDarstellung();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung#getMaximaleGeographischeBreite <em>Maximale Geographische Breite</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for the attribute '<em>Maximale Geographische Breite</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung#getMaximaleGeographischeBreite()
	 * @see #getMassstaeblicheDarstellung()
	 * @generated
	 */
	EAttribute getMassstaeblicheDarstellung_MaximaleGeographischeBreite();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung#getMinimaleGeographischeBreite <em>Minimale Geographische Breite</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for the attribute '<em>Minimale Geographische Breite</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung#getMinimaleGeographischeBreite()
	 * @see #getMassstaeblicheDarstellung()
	 * @generated
	 */
	EAttribute getMassstaeblicheDarstellung_MinimaleGeographischeBreite();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung#getMaximaleGeographischeLaenge <em>Maximale Geographische Laenge</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for the attribute '<em>Maximale Geographische Laenge</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung#getMaximaleGeographischeLaenge()
	 * @see #getMassstaeblicheDarstellung()
	 * @generated
	 */
	EAttribute getMassstaeblicheDarstellung_MaximaleGeographischeLaenge();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung#getMinimaleGeographischeLaenge <em>Minimale Geographische Laenge</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for the attribute '<em>Minimale Geographische Laenge</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung#getMinimaleGeographischeLaenge()
	 * @see #getMassstaeblicheDarstellung()
	 * @generated
	 */
	EAttribute getMassstaeblicheDarstellung_MinimaleGeographischeLaenge();

	/**
	 * Returns the meta object for class '
	 * {@link de.bsvrz.buv.plugin.darstellung.model.Ebene <em>Ebene</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Ebene</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Ebene
	 * @generated
	 */
	EClass getEbene();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.darstellung.model.Ebene#isVisible <em>Visible</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Visible</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Ebene#isVisible()
	 * @see #getEbene()
	 * @generated
	 */
	EAttribute getEbene_Visible();

	/**
	 * Returns the meta object for the container reference '{@link de.bsvrz.buv.plugin.darstellung.model.Ebene#getDarstellung <em>Darstellung</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Darstellung</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Ebene#getDarstellung()
	 * @see #getEbene()
	 * @generated
	 */
	EReference getEbene_Darstellung();

	/**
	 * Returns the meta object for the containment reference list '{@link de.bsvrz.buv.plugin.darstellung.model.Ebene#getDoObjekte <em>Do Objekte</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Do Objekte</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Ebene#getDoObjekte()
	 * @see #getEbene()
	 * @generated
	 */
	EReference getEbene_DoObjekte();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.darstellung.model.Ebene#getHintergrund <em>Hintergrund</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Hintergrund</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Ebene#getHintergrund()
	 * @see #getEbene()
	 * @generated
	 */
	EAttribute getEbene_Hintergrund();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.darstellung.model.Ebene#getHintergrundSkalierung <em>Hintergrund Skalierung</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for the attribute '<em>Hintergrund Skalierung</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Ebene#getHintergrundSkalierung()
	 * @see #getEbene()
	 * @generated
	 */
	EAttribute getEbene_HintergrundSkalierung();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.darstellung.model.Ebene#getHintergrundLocation <em>Hintergrund Location</em>}'.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the meta object for the attribute '<em>Hintergrund Location</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Ebene#getHintergrundLocation()
	 * @see #getEbene()
	 * @generated
	 */
	EAttribute getEbene_HintergrundLocation();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.darstellung.model.Ebene#isEditable <em>Editable</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Editable</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Ebene#isEditable()
	 * @see #getEbene()
	 * @generated
	 */
	EAttribute getEbene_Editable();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.darstellung.model.Ebene#isAusblendbar <em>Ausblendbar</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Ausblendbar</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Ebene#isAusblendbar()
	 * @see #getEbene()
	 * @generated
	 */
	EAttribute getEbene_Ausblendbar();

	/**
	 * Returns the meta object for class '
	 * {@link de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte
	 * <em>Darstellungs Spalte</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for class '<em>Darstellungs Spalte</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte
	 * @generated
	 */
	EClass getDarstellungsSpalte();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte#isVisible <em>Visible</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Visible</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte#isVisible()
	 * @see #getDarstellungsSpalte()
	 * @generated
	 */
	EAttribute getDarstellungsSpalte_Visible();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte#getWidth <em>Width</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Width</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte#getWidth()
	 * @see #getDarstellungsSpalte()
	 * @generated
	 */
	EAttribute getDarstellungsSpalte_Width();

	/**
	 * Returns the meta object for the reference list '{@link de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte#getDoObjekte <em>Do Objekte</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Do Objekte</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte#getDoObjekte()
	 * @see #getDarstellungsSpalte()
	 * @generated
	 */
	EReference getDarstellungsSpalte_DoObjekte();

	/**
	 * Returns the meta object for the container reference '{@link de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte#getDarstellung <em>Darstellung</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Darstellung</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte#getDarstellung()
	 * @see #getDarstellungsSpalte()
	 * @generated
	 */
	EReference getDarstellungsSpalte_Darstellung();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.darstellung.model.AutoEbene <em>Auto Ebene</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Auto Ebene</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.AutoEbene
	 * @generated
	 */
	EClass getAutoEbene();

	/**
	 * Returns the meta object for the attribute list '
	 * {@link de.bsvrz.buv.plugin.darstellung.model.AutoEbene#getSystemObjectTypes
	 * <em>System Object Types</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for the attribute list '
	 *         <em>System Object Types</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.AutoEbene#getSystemObjectTypes()
	 * @see #getAutoEbene()
	 * @generated
	 */
	EAttribute getAutoEbene_SystemObjectTypes();

	/**
	 * Returns the meta object for the attribute list '
	 * {@link de.bsvrz.buv.plugin.darstellung.model.AutoEbene#getConfigurationAreas
	 * <em>Configuration Areas</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for the attribute list '
	 *         <em>Configuration Areas</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.AutoEbene#getConfigurationAreas()
	 * @see #getAutoEbene()
	 * @generated
	 */
	EAttribute getAutoEbene_ConfigurationAreas();

	/**
	 * Returns the meta object for the attribute list '{@link de.bsvrz.buv.plugin.darstellung.model.AutoEbene#getSystemObjects <em>System Objects</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>System Objects</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.AutoEbene#getSystemObjects()
	 * @see #getAutoEbene()
	 * @generated
	 */
	EAttribute getAutoEbene_SystemObjects();

	/**
	 * Returns the meta object for the attribute list '{@link de.bsvrz.buv.plugin.darstellung.model.AutoEbene#getMutableSets <em>Mutable Sets</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Mutable Sets</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.AutoEbene#getMutableSets()
	 * @see #getAutoEbene()
	 * @generated
	 */
	EAttribute getAutoEbene_MutableSets();

	/**
	 * Returns the meta object for the reference list '{@link de.bsvrz.buv.plugin.darstellung.model.AutoEbene#getDoTypen <em>Do Typen</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Do Typen</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.AutoEbene#getDoTypen()
	 * @see #getAutoEbene()
	 * @generated
	 */
	EReference getAutoEbene_DoTypen();

	/**
	 * Returns the meta object for the reference list '{@link de.bsvrz.buv.plugin.darstellung.model.AutoEbene#getAutoDoObjekte <em>Auto Do Objekte</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Auto Do Objekte</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.AutoEbene#getAutoDoObjekte()
	 * @see #getAutoEbene()
	 * @generated
	 */
	EReference getAutoEbene_AutoDoObjekte();

	/**
	 * Returns the meta object for the attribute list '{@link de.bsvrz.buv.plugin.darstellung.model.AutoEbene#getSystemObjectsExcludes <em>System Objects Excludes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>System Objects Excludes</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.AutoEbene#getSystemObjectsExcludes()
	 * @see #getAutoEbene()
	 * @generated
	 */
	EAttribute getAutoEbene_SystemObjectsExcludes();

	/**
	 * Returns the meta object for class '{@link de.bsvrz.buv.plugin.darstellung.model.Ausschnitt <em>Ausschnitt</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for class '<em>Ausschnitt</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Ausschnitt
	 * @generated
	 */
	EClass getAusschnitt();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.darstellung.model.Ausschnitt#getBounds <em>Bounds</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Bounds</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Ausschnitt#getBounds()
	 * @see #getAusschnitt()
	 * @generated
	 */
	EAttribute getAusschnitt_Bounds();

	/**
	 * Returns the meta object for the attribute '{@link de.bsvrz.buv.plugin.darstellung.model.Ausschnitt#getZoomLevel <em>Zoom Level</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Zoom Level</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.Ausschnitt#getZoomLevel()
	 * @see #getAusschnitt()
	 * @generated
	 */
	EAttribute getAusschnitt_ZoomLevel();

	/**
	 * Returns the meta object for enum '{@link de.bsvrz.buv.plugin.darstellung.model.AnzeigeVerfahren <em>Anzeige Verfahren</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Anzeige Verfahren</em>'.
	 * @see de.bsvrz.buv.plugin.darstellung.model.AnzeigeVerfahren
	 * @generated
	 */
	EEnum getAnzeigeVerfahren();

	/**
	 * Returns the factory that creates the instances of the model. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	DarstellungFactory getDarstellungFactory();

	/**
	 * <!-- begin-user-doc --> Defines literals for the meta objects that
	 * represent
	 * <ul>
	 * <li>each class,</li>
	 * <li>each feature of each class,</li>
	 * <li>each enum,</li>
	 * <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungImpl <em>Darstellung</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungImpl
		 * @see de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungPackageImpl#getDarstellung()
		 * @generated
		 */
		EClass DARSTELLUNG = eINSTANCE.getDarstellung();

		/**
		 * The meta object literal for the '<em><b>Do Typen</b></em>' containment reference list feature.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @generated
		 */
		EReference DARSTELLUNG__DO_TYPEN = eINSTANCE.getDarstellung_DoTypen();

		/**
		 * The meta object literal for the '<em><b>Ebenen</b></em>' containment reference list feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference DARSTELLUNG__EBENEN = eINSTANCE.getDarstellung_Ebenen();

		/**
		 * The meta object literal for the '<em><b>Netz</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DARSTELLUNG__NETZ = eINSTANCE.getDarstellung_Netz();

		/**
		 * The meta object literal for the '<em><b>Zoom Skalierung</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DARSTELLUNG__ZOOM_SKALIERUNG = eINSTANCE.getDarstellung_ZoomSkalierung();

		/**
		 * The meta object literal for the '<em><b>Zoom Stufen</b></em>' attribute list feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DARSTELLUNG__ZOOM_STUFEN = eINSTANCE.getDarstellung_ZoomStufen();

		/**
		 * The meta object literal for the '<em><b>Properties</b></em>' map feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference DARSTELLUNG__PROPERTIES = eINSTANCE.getDarstellung_Properties();

		/**
		 * The meta object literal for the '<em><b>Verbindungslinie Farbe</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DARSTELLUNG__VERBINDUNGSLINIE_FARBE = eINSTANCE.getDarstellung_VerbindungslinieFarbe();

		/**
		 * The meta object literal for the '<em><b>Verbindungslinie Staerke</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DARSTELLUNG__VERBINDUNGSLINIE_STAERKE = eINSTANCE.getDarstellung_VerbindungslinieStaerke();

		/**
		 * The meta object literal for the '<em><b>Verbindungslinie Stil</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DARSTELLUNG__VERBINDUNGSLINIE_STIL = eINSTANCE.getDarstellung_VerbindungslinieStil();

		/**
		 * The meta object literal for the '<em><b>Stoerfallverfahren</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DARSTELLUNG__STOERFALLVERFAHREN = eINSTANCE.getDarstellung_Stoerfallverfahren();

		/**
		 * The meta object literal for the '<em><b>Anzeige Verfahren</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DARSTELLUNG__ANZEIGE_VERFAHREN = eINSTANCE.getDarstellung_AnzeigeVerfahren();

		/**
		 * The meta object literal for the '
		 * {@link de.bsvrz.buv.plugin.darstellung.model.impl.AnsichtImpl
		 * <em>Ansicht</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
		 * -->
		 * 
		 * @see de.bsvrz.buv.plugin.darstellung.model.impl.AnsichtImpl
		 * @see de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungPackageImpl#getAnsicht()
		 * @generated
		 */
		EClass ANSICHT = eINSTANCE.getAnsicht();

		/**
		 * The meta object literal for the '<em><b>Ausschnitt</b></em>' reference feature.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @generated
		 */
		EReference ANSICHT__AUSSCHNITT = eINSTANCE.getAnsicht_Ausschnitt();

		/**
		 * The meta object literal for the '<em><b>Darstellung</b></em>' containment reference feature.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @generated
		 */
		EReference ANSICHT__DARSTELLUNG = eINSTANCE.getAnsicht_Darstellung();

		/**
		 * The meta object literal for the '<em><b>Ausschnitte</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ANSICHT__AUSSCHNITTE = eINSTANCE.getAnsicht_Ausschnitte();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.darstellung.model.impl.StilisierteDarstellungImpl <em>Stilisierte Darstellung</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.darstellung.model.impl.StilisierteDarstellungImpl
		 * @see de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungPackageImpl#getStilisierteDarstellung()
		 * @generated
		 */
		EClass STILISIERTE_DARSTELLUNG = eINSTANCE.getStilisierteDarstellung();

		/**
		 * The meta object literal for the '<em><b>Spalten</b></em>' containment reference list feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference STILISIERTE_DARSTELLUNG__SPALTEN = eINSTANCE.getStilisierteDarstellung_Spalten();

		/**
		 * The meta object literal for the '<em><b>Spalten Border</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STILISIERTE_DARSTELLUNG__SPALTEN_BORDER = eINSTANCE.getStilisierteDarstellung_SpaltenBorder();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.darstellung.model.impl.MassstaeblicheDarstellungImpl <em>Massstaebliche Darstellung</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.darstellung.model.impl.MassstaeblicheDarstellungImpl
		 * @see de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungPackageImpl#getMassstaeblicheDarstellung()
		 * @generated
		 */
		EClass MASSSTAEBLICHE_DARSTELLUNG = eINSTANCE.getMassstaeblicheDarstellung();

		/**
		 * The meta object literal for the '<em><b>Maximale Geographische Breite</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MASSSTAEBLICHE_DARSTELLUNG__MAXIMALE_GEOGRAPHISCHE_BREITE = eINSTANCE
				.getMassstaeblicheDarstellung_MaximaleGeographischeBreite();

		/**
		 * The meta object literal for the '<em><b>Minimale Geographische Breite</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MASSSTAEBLICHE_DARSTELLUNG__MINIMALE_GEOGRAPHISCHE_BREITE = eINSTANCE
				.getMassstaeblicheDarstellung_MinimaleGeographischeBreite();

		/**
		 * The meta object literal for the '<em><b>Maximale Geographische Laenge</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MASSSTAEBLICHE_DARSTELLUNG__MAXIMALE_GEOGRAPHISCHE_LAENGE = eINSTANCE
				.getMassstaeblicheDarstellung_MaximaleGeographischeLaenge();

		/**
		 * The meta object literal for the '<em><b>Minimale Geographische Laenge</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MASSSTAEBLICHE_DARSTELLUNG__MINIMALE_GEOGRAPHISCHE_LAENGE = eINSTANCE
				.getMassstaeblicheDarstellung_MinimaleGeographischeLaenge();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.darstellung.model.impl.EbeneImpl <em>Ebene</em>}' class.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.darstellung.model.impl.EbeneImpl
		 * @see de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungPackageImpl#getEbene()
		 * @generated
		 */
		EClass EBENE = eINSTANCE.getEbene();

		/**
		 * The meta object literal for the '<em><b>Visible</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EBENE__VISIBLE = eINSTANCE.getEbene_Visible();

		/**
		 * The meta object literal for the '<em><b>Darstellung</b></em>' container reference feature.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @generated
		 */
		EReference EBENE__DARSTELLUNG = eINSTANCE.getEbene_Darstellung();

		/**
		 * The meta object literal for the '<em><b>Do Objekte</b></em>' containment reference list feature.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @generated
		 */
		EReference EBENE__DO_OBJEKTE = eINSTANCE.getEbene_DoObjekte();

		/**
		 * The meta object literal for the '<em><b>Hintergrund</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EBENE__HINTERGRUND = eINSTANCE.getEbene_Hintergrund();

		/**
		 * The meta object literal for the '
		 * <em><b>Hintergrund Skalierung</b></em>' attribute feature. <!--
		 * begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute EBENE__HINTERGRUND_SKALIERUNG = eINSTANCE.getEbene_HintergrundSkalierung();

		/**
		 * The meta object literal for the '<em><b>Hintergrund Location</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EBENE__HINTERGRUND_LOCATION = eINSTANCE.getEbene_HintergrundLocation();

		/**
		 * The meta object literal for the '<em><b>Editable</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EBENE__EDITABLE = eINSTANCE.getEbene_Editable();

		/**
		 * The meta object literal for the '<em><b>Ausblendbar</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EBENE__AUSBLENDBAR = eINSTANCE.getEbene_Ausblendbar();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungsSpalteImpl <em>Darstellungs Spalte</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungsSpalteImpl
		 * @see de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungPackageImpl#getDarstellungsSpalte()
		 * @generated
		 */
		EClass DARSTELLUNGS_SPALTE = eINSTANCE.getDarstellungsSpalte();

		/**
		 * The meta object literal for the '<em><b>Visible</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DARSTELLUNGS_SPALTE__VISIBLE = eINSTANCE.getDarstellungsSpalte_Visible();

		/**
		 * The meta object literal for the '<em><b>Width</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DARSTELLUNGS_SPALTE__WIDTH = eINSTANCE.getDarstellungsSpalte_Width();

		/**
		 * The meta object literal for the '<em><b>Do Objekte</b></em>' reference list feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference DARSTELLUNGS_SPALTE__DO_OBJEKTE = eINSTANCE.getDarstellungsSpalte_DoObjekte();

		/**
		 * The meta object literal for the '<em><b>Darstellung</b></em>' container reference feature.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @generated
		 */
		EReference DARSTELLUNGS_SPALTE__DARSTELLUNG = eINSTANCE.getDarstellungsSpalte_Darstellung();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.darstellung.model.impl.AutoEbeneImpl <em>Auto Ebene</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.darstellung.model.impl.AutoEbeneImpl
		 * @see de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungPackageImpl#getAutoEbene()
		 * @generated
		 */
		EClass AUTO_EBENE = eINSTANCE.getAutoEbene();

		/**
		 * The meta object literal for the '<em><b>System Object Types</b></em>' attribute list feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AUTO_EBENE__SYSTEM_OBJECT_TYPES = eINSTANCE.getAutoEbene_SystemObjectTypes();

		/**
		 * The meta object literal for the '<em><b>Configuration Areas</b></em>' attribute list feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AUTO_EBENE__CONFIGURATION_AREAS = eINSTANCE.getAutoEbene_ConfigurationAreas();

		/**
		 * The meta object literal for the '<em><b>System Objects</b></em>' attribute list feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AUTO_EBENE__SYSTEM_OBJECTS = eINSTANCE.getAutoEbene_SystemObjects();

		/**
		 * The meta object literal for the '<em><b>Mutable Sets</b></em>' attribute list feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AUTO_EBENE__MUTABLE_SETS = eINSTANCE.getAutoEbene_MutableSets();

		/**
		 * The meta object literal for the '<em><b>Do Typen</b></em>' reference list feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference AUTO_EBENE__DO_TYPEN = eINSTANCE.getAutoEbene_DoTypen();

		/**
		 * The meta object literal for the '<em><b>Auto Do Objekte</b></em>' reference list feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EReference AUTO_EBENE__AUTO_DO_OBJEKTE = eINSTANCE.getAutoEbene_AutoDoObjekte();

		/**
		 * The meta object literal for the '<em><b>System Objects Excludes</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AUTO_EBENE__SYSTEM_OBJECTS_EXCLUDES = eINSTANCE.getAutoEbene_SystemObjectsExcludes();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.darstellung.model.impl.AusschnittImpl <em>Ausschnitt</em>}' class.
		 * <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * @see de.bsvrz.buv.plugin.darstellung.model.impl.AusschnittImpl
		 * @see de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungPackageImpl#getAusschnitt()
		 * @generated
		 */
		EClass AUSSCHNITT = eINSTANCE.getAusschnitt();

		/**
		 * The meta object literal for the '<em><b>Bounds</b></em>' attribute feature.
		 * <!-- begin-user-doc --> <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AUSSCHNITT__BOUNDS = eINSTANCE.getAusschnitt_Bounds();

		/**
		 * The meta object literal for the '<em><b>Zoom Level</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AUSSCHNITT__ZOOM_LEVEL = eINSTANCE.getAusschnitt_ZoomLevel();

		/**
		 * The meta object literal for the '{@link de.bsvrz.buv.plugin.darstellung.model.AnzeigeVerfahren <em>Anzeige Verfahren</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.bsvrz.buv.plugin.darstellung.model.AnzeigeVerfahren
		 * @see de.bsvrz.buv.plugin.darstellung.model.impl.DarstellungPackageImpl#getAnzeigeVerfahren()
		 * @generated
		 */
		EEnum ANZEIGE_VERFAHREN = eINSTANCE.getAnzeigeVerfahren();

	}

} // DarstellungPackage
