/**
 * Darstellungsobjekte
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.darstellung.model;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>Stilisierte Darstellung</b></em>'. <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung#getSpalten <em>Spalten</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung#isSpaltenBorder <em>Spalten Border</em>}</li>
 * </ul>
 *
 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getStilisierteDarstellung()
 * @model
 * @generated
 */
public interface StilisierteDarstellung extends Darstellung {

	/**
	 * Returns the value of the '<em><b>Spalten</b></em>' containment reference list.
	 * The list contents are of type {@link de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte}.
	 * It is bidirectional and its opposite is '{@link de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte#getDarstellung <em>Darstellung</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Spalten</em>' containment reference list isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Spalten</em>' containment reference list.
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getStilisierteDarstellung_Spalten()
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte#getDarstellung
	 * @model opposite="darstellung" containment="true"
	 * @generated
	 */
	EList<DarstellungsSpalte> getSpalten();

	/**
	 * Returns the value of the '<em><b>Spalten Border</b></em>' attribute.
	 * The default value is <code>"false"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Spalten Border</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Spalten Border</em>' attribute.
	 * @see #setSpaltenBorder(boolean)
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#getStilisierteDarstellung_SpaltenBorder()
	 * @model default="false" transient="true"
	 * @generated
	 */
	boolean isSpaltenBorder();

	/**
	 * Sets the value of the '{@link de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung#isSpaltenBorder <em>Spalten Border</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @param value the new value of the '<em>Spalten Border</em>' attribute.
	 * @see #isSpaltenBorder()
	 * @generated
	 */
	void setSpaltenBorder(boolean value);

} // StilisierteDarstellung
