/**
 * Darstellungsobjekte
 * Copyright (C) 2010 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.darstellung.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;

import de.bsvrz.buv.plugin.darstellung.model.AutoEbene;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.dobj.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.MutableSet;
import de.bsvrz.dav.daf.main.config.ObjectTimeSpecification;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.debug.Debug;

/**
 * <!-- begin-user-doc --> An implementation of the model object ' <em><b>Auto
 * Ebene</b></em>'.
 *
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.AutoEbeneImpl#getSystemObjectTypes <em>System Object Types</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.AutoEbeneImpl#getConfigurationAreas <em>Configuration Areas</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.AutoEbeneImpl#getSystemObjects <em>System Objects</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.AutoEbeneImpl#getMutableSets <em>Mutable Sets</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.AutoEbeneImpl#getDoTypen <em>Do Typen</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.AutoEbeneImpl#getAutoDoObjekte <em>Auto Do Objekte</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.AutoEbeneImpl#getSystemObjectsExcludes <em>System Objects Excludes</em>}</li>
 * </ul>
 *
 * @generated
 */
public class AutoEbeneImpl extends EbeneImpl implements AutoEbene {
	/**
	 * The cached value of the '{@link #getSystemObjectTypes() <em>System Object Types</em>}' attribute list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getSystemObjectTypes()
	 * @generated
	 * @ordered
	 */
	protected EList<SystemObjectType> systemObjectTypes;

	/**
	 * The cached value of the '{@link #getConfigurationAreas() <em>Configuration Areas</em>}' attribute list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getConfigurationAreas()
	 * @generated
	 * @ordered
	 */
	protected EList<ConfigurationArea> configurationAreas;

	/**
	 * The cached value of the '{@link #getSystemObjects() <em>System Objects</em>}' attribute list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getSystemObjects()
	 * @generated
	 * @ordered
	 */
	protected EList<SystemObject> systemObjects;

	/**
	 * The cached value of the '{@link #getMutableSets() <em>Mutable Sets</em>}' attribute list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getMutableSets()
	 * @generated
	 * @ordered
	 */
	protected EList<MutableSet> mutableSets;

	/**
	 * The cached value of the '{@link #getDoTypen() <em>Do Typen</em>}' reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getDoTypen()
	 * @generated
	 * @ordered
	 */
	protected EList<DoTyp> doTypen;

	/**
	 * The cached value of the '{@link #getAutoDoObjekte() <em>Auto Do Objekte</em>}' reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getAutoDoObjekte()
	 * @generated
	 * @ordered
	 */
	protected EList<DoModel> autoDoObjekte;

	/**
	 * The cached value of the '{@link #getSystemObjectsExcludes() <em>System Objects Excludes</em>}' attribute list.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #getSystemObjectsExcludes()
	 * @generated
	 * @ordered
	 */
	protected EList<SystemObject> systemObjectsExcludes;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	protected AutoEbeneImpl() {
		super();

		eAdapters().add(new AdapterImpl() {

			@Override
			public void notifyChanged(final Notification notification) {
				super.notifyChanged(notification);

				final Object notifier = notification.getNotifier();
				final int type = notification.getEventType();
				final int featureID = notification.getFeatureID(Ebene.class);

				if (notifier instanceof AutoEbene) {
					switch (type) {
					case Notification.ADD:
					case Notification.ADD_MANY:
					case Notification.REMOVE:
					case Notification.REMOVE_MANY:
					case Notification.MOVE:
						switch (featureID) {
						case DarstellungPackage.AUTO_EBENE__SYSTEM_OBJECT_TYPES:
						case DarstellungPackage.AUTO_EBENE__CONFIGURATION_AREAS:
						case DarstellungPackage.AUTO_EBENE__MUTABLE_SETS:
						case DarstellungPackage.AUTO_EBENE__SYSTEM_OBJECTS:
						case DarstellungPackage.AUTO_EBENE__DO_TYPEN:
							autoDoObjekte = null;
							break;
						}
						break;
					}
				}
			}

		});
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DarstellungPackage.Literals.AUTO_EBENE;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<SystemObjectType> getSystemObjectTypes() {
		if (systemObjectTypes == null) {
			systemObjectTypes = new EDataTypeUniqueEList<SystemObjectType>(SystemObjectType.class, this,
					DarstellungPackage.AUTO_EBENE__SYSTEM_OBJECT_TYPES);
		}
		return systemObjectTypes;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ConfigurationArea> getConfigurationAreas() {
		if (configurationAreas == null) {
			configurationAreas = new EDataTypeUniqueEList<ConfigurationArea>(ConfigurationArea.class, this,
					DarstellungPackage.AUTO_EBENE__CONFIGURATION_AREAS);
		}
		return configurationAreas;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<SystemObject> getSystemObjects() {
		if (systemObjects == null) {
			systemObjects = new EDataTypeUniqueEList<SystemObject>(SystemObject.class, this,
					DarstellungPackage.AUTO_EBENE__SYSTEM_OBJECTS);
		}
		return systemObjects;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<MutableSet> getMutableSets() {
		if (mutableSets == null) {
			mutableSets = new EDataTypeUniqueEList<MutableSet>(MutableSet.class, this,
					DarstellungPackage.AUTO_EBENE__MUTABLE_SETS);
		}
		return mutableSets;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<DoTyp> getDoTypen() {
		if (doTypen == null) {
			doTypen = new EObjectResolvingEList<DoTyp>(DoTyp.class, this, DarstellungPackage.AUTO_EBENE__DO_TYPEN);
		}
		return doTypen;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	@Override
	public EList<DoModel> getAutoDoObjekte() {
		// Ensure that you remove @generated or mark it @generated NOT
		// The list is expected to implement
		// org.eclipse.emf.ecore.util.InternalEList and
		// org.eclipse.emf.ecore.EStructuralFeature.Setting
		// so it's likely that an appropriate subclass of
		// org.eclipse.emf.ecore.util.EcoreEList should be used.

		// Hier sollte nicht gecached werden: Weil: AutoebeneEditPart für
		// dynamische Objekte nicht add und remove auswertet sondern alles immer
		// neu ausliest!
		// if (autoDoObjekte != null) {
		// return autoDoObjekte;
		// }

		long t = System.currentTimeMillis();

		autoDoObjekte = new BasicEList<DoModel>();

		final List<DoTyp> doTypenCopy = new ArrayList<DoTyp>(getDoTypen());
		if (doTypenCopy.isEmpty()) {
			return ECollections.emptyEList();
		}

		final List<SystemObjectType> systemObjectTypesCopy = new ArrayList<SystemObjectType>(getSystemObjectTypes());
		final List<ConfigurationArea> configurationAreasCopy = new ArrayList<ConfigurationArea>(
				getConfigurationAreas());
		final List<MutableSet> mutableSetsCopy = new ArrayList<MutableSet>(getMutableSets());
		final List<SystemObject> systemObjectsCopy = new ArrayList<SystemObject>(getSystemObjects());
		final Set<SystemObject> systemObjectsExcludesCopy = new HashSet<SystemObject>(getSystemObjectsExcludes());

		// Liste der anzuzeigenden Systemobjekte
		final Set<SystemObject> objects = new HashSet<SystemObject>();

		// Aus der Liste der Systemobjekte wird das Ergebnis generiert
		final List<SystemObjectType> configuratedObjectTypes = new ArrayList<SystemObjectType>();
		final List<SystemObjectType> dynamicObjectTypes = new ArrayList<SystemObjectType>();
		for (final SystemObjectType sot : systemObjectTypesCopy) {
			if (sot.isConfigurating()) {
				configuratedObjectTypes.add(sot);
			} else {
				dynamicObjectTypes.add(sot);
			}
		}

		/*
		 * Systemobjekttypen und Konfigurationsbereiche nur auflösen, wenn eine der
		 * beiden Listen nicht leer ist. Es werden nur konfigurierende Systemobjekttypen
		 * berücksichtigt.
		 */
		if ((!configuratedObjectTypes.isEmpty() || !configurationAreasCopy.isEmpty())
				&& RahmenwerkService.getService().getObjektFactory().isVerbunden()) {

			final DataModel model = RahmenwerkService.getService().getObjektFactory().getDav().getDataModel();

			objects.addAll(model.getObjects(configurationAreasCopy.isEmpty() ? null : configurationAreasCopy,
					configuratedObjectTypes.isEmpty() ? null : configuratedObjectTypes,
					ObjectTimeSpecification.valid()));
		}

		// Ggf. Einzelangaben für Systemobjekten ergänzen
		for (final SystemObject so : systemObjectsCopy) {
			if (!objects.contains(so)) {
				objects.add(so);
			}
		}

		/*
		 * Nur die Objekte aus den angegebenen Mengen werden übernommen, die einem der
		 * angegebenen Systemobjekttypen entsprechen.
		 */
		for (final MutableSet set : mutableSetsCopy) {
			for (final SystemObject so : set.getElements()) {
				if (dynamicObjectTypes.isEmpty() || dynamicObjectTypes.contains(so.getType())) {
					objects.add(so);
				}
			}
		}

		/*
		 * Einzelne Systemobjekt in Ergebnis aufnehmen.
		 */
		for (final SystemObject so : objects) {
			// ausschließende Liste für Systemobjekte beachten
			if (systemObjectsExcludesCopy.contains(so)) {
				continue;
			}

			for (final DoTyp doTyp : doTypenCopy) {
				if (doTyp.getSystemObjectType() != null && so.isOfType(doTyp.getSystemObjectType())) {
					final DoModel doModel = doTyp.createModel();
					doModel.setSystemObject(so);
					autoDoObjekte.add(doModel);
				}
			}
		}

		t = System.currentTimeMillis() - t;
		Debug.getLogger().fine(
				getClass().getSimpleName() + "#getAutoDoObjekte(Ebene=" + getName() + "): " + (t / 1000) + " Sekunden");

		return autoDoObjekte;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<SystemObject> getSystemObjectsExcludes() {
		if (systemObjectsExcludes == null) {
			systemObjectsExcludes = new EDataTypeUniqueEList<SystemObject>(SystemObject.class, this,
					DarstellungPackage.AUTO_EBENE__SYSTEM_OBJECTS_EXCLUDES);
		}
		return systemObjectsExcludes;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	@Override
	public boolean isAutomatischVerwaltbar(final DoModel modellObjekt) {
		return getDoTypen().contains(modellObjekt.getDoTyp());
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated NOT
	 */
	@Override
	public boolean isAutomatischVerwaltet(final DoModel modellObjekt) {
		return !getSystemObjectsExcludes().contains(modellObjekt.getSystemObject())
				&& !getDoObjekte().contains(modellObjekt) && modellObjekt.getLocation() == null;
		// Entspricht:
		// return getAutoDoObjekte().contains(modellObjekt);
		// ist aber performanter, da die Liste der AutoObjekte nicht jedesmal
		// neu berechnet wird.
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DarstellungPackage.AUTO_EBENE__SYSTEM_OBJECT_TYPES:
			return getSystemObjectTypes();
		case DarstellungPackage.AUTO_EBENE__CONFIGURATION_AREAS:
			return getConfigurationAreas();
		case DarstellungPackage.AUTO_EBENE__SYSTEM_OBJECTS:
			return getSystemObjects();
		case DarstellungPackage.AUTO_EBENE__MUTABLE_SETS:
			return getMutableSets();
		case DarstellungPackage.AUTO_EBENE__DO_TYPEN:
			return getDoTypen();
		case DarstellungPackage.AUTO_EBENE__AUTO_DO_OBJEKTE:
			return getAutoDoObjekte();
		case DarstellungPackage.AUTO_EBENE__SYSTEM_OBJECTS_EXCLUDES:
			return getSystemObjectsExcludes();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DarstellungPackage.AUTO_EBENE__SYSTEM_OBJECT_TYPES:
			getSystemObjectTypes().clear();
			getSystemObjectTypes().addAll((Collection<? extends SystemObjectType>) newValue);
			return;
		case DarstellungPackage.AUTO_EBENE__CONFIGURATION_AREAS:
			getConfigurationAreas().clear();
			getConfigurationAreas().addAll((Collection<? extends ConfigurationArea>) newValue);
			return;
		case DarstellungPackage.AUTO_EBENE__SYSTEM_OBJECTS:
			getSystemObjects().clear();
			getSystemObjects().addAll((Collection<? extends SystemObject>) newValue);
			return;
		case DarstellungPackage.AUTO_EBENE__MUTABLE_SETS:
			getMutableSets().clear();
			getMutableSets().addAll((Collection<? extends MutableSet>) newValue);
			return;
		case DarstellungPackage.AUTO_EBENE__DO_TYPEN:
			getDoTypen().clear();
			getDoTypen().addAll((Collection<? extends DoTyp>) newValue);
			return;
		case DarstellungPackage.AUTO_EBENE__SYSTEM_OBJECTS_EXCLUDES:
			getSystemObjectsExcludes().clear();
			getSystemObjectsExcludes().addAll((Collection<? extends SystemObject>) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DarstellungPackage.AUTO_EBENE__SYSTEM_OBJECT_TYPES:
			getSystemObjectTypes().clear();
			return;
		case DarstellungPackage.AUTO_EBENE__CONFIGURATION_AREAS:
			getConfigurationAreas().clear();
			return;
		case DarstellungPackage.AUTO_EBENE__SYSTEM_OBJECTS:
			getSystemObjects().clear();
			return;
		case DarstellungPackage.AUTO_EBENE__MUTABLE_SETS:
			getMutableSets().clear();
			return;
		case DarstellungPackage.AUTO_EBENE__DO_TYPEN:
			getDoTypen().clear();
			return;
		case DarstellungPackage.AUTO_EBENE__SYSTEM_OBJECTS_EXCLUDES:
			getSystemObjectsExcludes().clear();
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DarstellungPackage.AUTO_EBENE__SYSTEM_OBJECT_TYPES:
			return systemObjectTypes != null && !systemObjectTypes.isEmpty();
		case DarstellungPackage.AUTO_EBENE__CONFIGURATION_AREAS:
			return configurationAreas != null && !configurationAreas.isEmpty();
		case DarstellungPackage.AUTO_EBENE__SYSTEM_OBJECTS:
			return systemObjects != null && !systemObjects.isEmpty();
		case DarstellungPackage.AUTO_EBENE__MUTABLE_SETS:
			return mutableSets != null && !mutableSets.isEmpty();
		case DarstellungPackage.AUTO_EBENE__DO_TYPEN:
			return doTypen != null && !doTypen.isEmpty();
		case DarstellungPackage.AUTO_EBENE__AUTO_DO_OBJEKTE:
			return autoDoObjekte != null && !autoDoObjekte.isEmpty();
		case DarstellungPackage.AUTO_EBENE__SYSTEM_OBJECTS_EXCLUDES:
			return systemObjectsExcludes != null && !systemObjectsExcludes.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (systemObjectTypes: ");
		result.append(systemObjectTypes);
		result.append(", configurationAreas: ");
		result.append(configurationAreas);
		result.append(", systemObjects: ");
		result.append(systemObjects);
		result.append(", mutableSets: ");
		result.append(mutableSets);
		result.append(", systemObjectsExcludes: ");
		result.append(systemObjectsExcludes);
		result.append(')');
		return result.toString();
	}

} // AutoEbeneImpl
