/**
 * Darstellungsobjekte
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.darstellung.model.impl;

import de.bsvrz.buv.plugin.darstellung.model.*;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

import de.bsvrz.buv.plugin.darstellung.model.Ansicht;
import de.bsvrz.buv.plugin.darstellung.model.Ausschnitt;
import de.bsvrz.buv.plugin.darstellung.model.AutoEbene;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungFactory;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung;
import de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung;
import de.bsvrz.buv.plugin.darstellung.model.util.DarstellungAdapterFactory;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Factory</b>. <!--
 * end-user-doc -->
 * @generated
 */
public class DarstellungFactoryImpl extends EFactoryImpl implements DarstellungFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	public static DarstellungFactory init() {
		try {
			DarstellungFactory theDarstellungFactory = (DarstellungFactory) EPackage.Registry.INSTANCE
					.getEFactory(DarstellungPackage.eNS_URI);
			if (theDarstellungFactory != null) {
				return theDarstellungFactory;
			}
		} catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new DarstellungFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	public DarstellungFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
		case DarstellungPackage.ANSICHT:
			return createAnsicht();
		case DarstellungPackage.STILISIERTE_DARSTELLUNG:
			return createStilisierteDarstellung();
		case DarstellungPackage.MASSSTAEBLICHE_DARSTELLUNG:
			return createMassstaeblicheDarstellung();
		case DarstellungPackage.EBENE:
			return createEbene();
		case DarstellungPackage.DARSTELLUNGS_SPALTE:
			return createDarstellungsSpalte();
		case DarstellungPackage.AUTO_EBENE:
			return createAutoEbene();
		case DarstellungPackage.AUSSCHNITT:
			return createAusschnitt();
		default:
			throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
		case DarstellungPackage.ANZEIGE_VERFAHREN:
			return createAnzeigeVerfahrenFromString(eDataType, initialValue);
		default:
			throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
		case DarstellungPackage.ANZEIGE_VERFAHREN:
			return convertAnzeigeVerfahrenToString(eDataType, instanceValue);
		default:
			throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Ansicht createAnsicht() {
		AnsichtImpl ansicht = new AnsichtImpl();
		return ansicht;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated not
	 */
	@Override
	public StilisierteDarstellung createStilisierteDarstellung() {
		final StilisierteDarstellungImpl stilisierteDarstellung = new StilisierteDarstellungImpl();
		new DarstellungAdapterFactory().adapt(stilisierteDarstellung, Darstellung.class);
		return stilisierteDarstellung;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated not
	 */
	@Override
	public MassstaeblicheDarstellung createMassstaeblicheDarstellung() {
		final MassstaeblicheDarstellungImpl massstaeblicheDarstellung = new MassstaeblicheDarstellungImpl();
		new DarstellungAdapterFactory().adapt(massstaeblicheDarstellung, Darstellung.class);
		return massstaeblicheDarstellung;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Ebene createEbene() {
		EbeneImpl ebene = new EbeneImpl();
		return ebene;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DarstellungsSpalte createDarstellungsSpalte() {
		DarstellungsSpalteImpl darstellungsSpalte = new DarstellungsSpalteImpl();
		return darstellungsSpalte;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AutoEbene createAutoEbene() {
		AutoEbeneImpl autoEbene = new AutoEbeneImpl();
		return autoEbene;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Ausschnitt createAusschnitt() {
		AusschnittImpl ausschnitt = new AusschnittImpl();
		return ausschnitt;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AnzeigeVerfahren createAnzeigeVerfahrenFromString(EDataType eDataType, String initialValue) {
		AnzeigeVerfahren result = AnzeigeVerfahren.get(initialValue);
		if (result == null)
			throw new IllegalArgumentException(
					"The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertAnzeigeVerfahrenToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DarstellungPackage getDarstellungPackage() {
		return (DarstellungPackage) getEPackage();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static DarstellungPackage getPackage() {
		return DarstellungPackage.eINSTANCE;
	}

} // DarstellungFactoryImpl
