/**
 * Darstellungsobjekte
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.darstellung.model.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.impl.EPackageImpl;

import com.bitctrl.lib.eclipse.emf.dav.model.DavPackage;
import com.bitctrl.lib.eclipse.emf.davbitctrl.model.DavbitctrlPackage;
import com.bitctrl.lib.eclipse.emf.eclipse.model.EclipsePackage;
import com.bitctrl.lib.eclipse.emf.gef.model.GefPackage;

import de.bsvrz.buv.plugin.darstellung.model.Ansicht;
import de.bsvrz.buv.plugin.darstellung.model.AnzeigeVerfahren;
import de.bsvrz.buv.plugin.darstellung.model.Ausschnitt;
import de.bsvrz.buv.plugin.darstellung.model.AutoEbene;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungFactory;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung;
import de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung;
import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.model.DobjPackage;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Package</b>. <!--
 * end-user-doc -->
 * @generated
 */
public class DarstellungPackageImpl extends EPackageImpl implements DarstellungPackage {
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass darstellungEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass ansichtEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass stilisierteDarstellungEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass massstaeblicheDarstellungEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass ebeneEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass darstellungsSpalteEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass autoEbeneEClass = null;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private EClass ausschnittEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum anzeigeVerfahrenEEnum = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the
	 * package package URI value.
	 * <p>
	 * Note: the correct way to create the package is via the static factory
	 * method {@link #init init()}, which also performs initialization of the
	 * package, or returns the registered package, if one already exists. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private DarstellungPackageImpl() {
		super(eNS_URI, DarstellungFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model,
	 * and for any others upon which it depends.
	 * 
	 * <p>
	 * This method is used to initialize {@link DarstellungPackage#eINSTANCE}
	 * when that field is accessed. Clients should not invoke it directly.
	 * Instead, they should simply access that field to obtain the package. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static DarstellungPackage init() {
		if (isInited)
			return (DarstellungPackage) EPackage.Registry.INSTANCE.getEPackage(DarstellungPackage.eNS_URI);

		// Obtain or create and register package
		Object registeredDarstellungPackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		DarstellungPackageImpl theDarstellungPackage = registeredDarstellungPackage instanceof DarstellungPackageImpl
				? (DarstellungPackageImpl) registeredDarstellungPackage
				: new DarstellungPackageImpl();

		isInited = true;

		// Initialize simple dependencies
		DavPackage.eINSTANCE.eClass();
		DavbitctrlPackage.eINSTANCE.eClass();
		DobjPackage.eINSTANCE.eClass();
		DobjDecoratorPackage.eINSTANCE.eClass();
		EclipsePackage.eINSTANCE.eClass();
		GefPackage.eINSTANCE.eClass();

		// Create package meta-data objects
		theDarstellungPackage.createPackageContents();

		// Initialize created meta-data
		theDarstellungPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theDarstellungPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(DarstellungPackage.eNS_URI, theDarstellungPackage);
		return theDarstellungPackage;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDarstellung() {
		return darstellungEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDarstellung_DoTypen() {
		return (EReference) darstellungEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDarstellung_Ebenen() {
		return (EReference) darstellungEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDarstellung_Netz() {
		return (EAttribute) darstellungEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDarstellung_ZoomSkalierung() {
		return (EAttribute) darstellungEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDarstellung_ZoomStufen() {
		return (EAttribute) darstellungEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDarstellung_Properties() {
		return (EReference) darstellungEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDarstellung_VerbindungslinieFarbe() {
		return (EAttribute) darstellungEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDarstellung_VerbindungslinieStaerke() {
		return (EAttribute) darstellungEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDarstellung_VerbindungslinieStil() {
		return (EAttribute) darstellungEClass.getEStructuralFeatures().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDarstellung_Stoerfallverfahren() {
		return (EAttribute) darstellungEClass.getEStructuralFeatures().get(9);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDarstellung_AnzeigeVerfahren() {
		return (EAttribute) darstellungEClass.getEStructuralFeatures().get(10);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAnsicht() {
		return ansichtEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAnsicht_Ausschnitt() {
		return (EReference) ansichtEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAnsicht_Darstellung() {
		return (EReference) ansichtEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAnsicht_Ausschnitte() {
		return (EReference) ansichtEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getStilisierteDarstellung() {
		return stilisierteDarstellungEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getStilisierteDarstellung_Spalten() {
		return (EReference) stilisierteDarstellungEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getStilisierteDarstellung_SpaltenBorder() {
		return (EAttribute) stilisierteDarstellungEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getMassstaeblicheDarstellung() {
		return massstaeblicheDarstellungEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getMassstaeblicheDarstellung_MaximaleGeographischeBreite() {
		return (EAttribute) massstaeblicheDarstellungEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getMassstaeblicheDarstellung_MinimaleGeographischeBreite() {
		return (EAttribute) massstaeblicheDarstellungEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getMassstaeblicheDarstellung_MaximaleGeographischeLaenge() {
		return (EAttribute) massstaeblicheDarstellungEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getMassstaeblicheDarstellung_MinimaleGeographischeLaenge() {
		return (EAttribute) massstaeblicheDarstellungEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getEbene() {
		return ebeneEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getEbene_Visible() {
		return (EAttribute) ebeneEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getEbene_Darstellung() {
		return (EReference) ebeneEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getEbene_DoObjekte() {
		return (EReference) ebeneEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getEbene_Hintergrund() {
		return (EAttribute) ebeneEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getEbene_HintergrundSkalierung() {
		return (EAttribute) ebeneEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getEbene_HintergrundLocation() {
		return (EAttribute) ebeneEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getEbene_Editable() {
		return (EAttribute) ebeneEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getEbene_Ausblendbar() {
		return (EAttribute) ebeneEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDarstellungsSpalte() {
		return darstellungsSpalteEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDarstellungsSpalte_Visible() {
		return (EAttribute) darstellungsSpalteEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDarstellungsSpalte_Width() {
		return (EAttribute) darstellungsSpalteEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDarstellungsSpalte_DoObjekte() {
		return (EReference) darstellungsSpalteEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDarstellungsSpalte_Darstellung() {
		return (EReference) darstellungsSpalteEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAutoEbene() {
		return autoEbeneEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getAutoEbene_SystemObjectTypes() {
		return (EAttribute) autoEbeneEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getAutoEbene_ConfigurationAreas() {
		return (EAttribute) autoEbeneEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getAutoEbene_SystemObjects() {
		return (EAttribute) autoEbeneEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getAutoEbene_MutableSets() {
		return (EAttribute) autoEbeneEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAutoEbene_DoTypen() {
		return (EReference) autoEbeneEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAutoEbene_AutoDoObjekte() {
		return (EReference) autoEbeneEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getAutoEbene_SystemObjectsExcludes() {
		return (EAttribute) autoEbeneEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAusschnitt() {
		return ausschnittEClass;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getAusschnitt_Bounds() {
		return (EAttribute) ausschnittEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getAusschnitt_ZoomLevel() {
		return (EAttribute) ausschnittEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getAnzeigeVerfahren() {
		return anzeigeVerfahrenEEnum;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public DarstellungFactory getDarstellungFactory() {
		return (DarstellungFactory) getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated)
			return;
		isCreated = true;

		// Create classes and their features
		darstellungEClass = createEClass(DARSTELLUNG);
		createEReference(darstellungEClass, DARSTELLUNG__DO_TYPEN);
		createEReference(darstellungEClass, DARSTELLUNG__EBENEN);
		createEAttribute(darstellungEClass, DARSTELLUNG__NETZ);
		createEAttribute(darstellungEClass, DARSTELLUNG__ZOOM_SKALIERUNG);
		createEAttribute(darstellungEClass, DARSTELLUNG__ZOOM_STUFEN);
		createEReference(darstellungEClass, DARSTELLUNG__PROPERTIES);
		createEAttribute(darstellungEClass, DARSTELLUNG__VERBINDUNGSLINIE_FARBE);
		createEAttribute(darstellungEClass, DARSTELLUNG__VERBINDUNGSLINIE_STAERKE);
		createEAttribute(darstellungEClass, DARSTELLUNG__VERBINDUNGSLINIE_STIL);
		createEAttribute(darstellungEClass, DARSTELLUNG__STOERFALLVERFAHREN);
		createEAttribute(darstellungEClass, DARSTELLUNG__ANZEIGE_VERFAHREN);

		ansichtEClass = createEClass(ANSICHT);
		createEReference(ansichtEClass, ANSICHT__AUSSCHNITT);
		createEReference(ansichtEClass, ANSICHT__DARSTELLUNG);
		createEReference(ansichtEClass, ANSICHT__AUSSCHNITTE);

		stilisierteDarstellungEClass = createEClass(STILISIERTE_DARSTELLUNG);
		createEReference(stilisierteDarstellungEClass, STILISIERTE_DARSTELLUNG__SPALTEN);
		createEAttribute(stilisierteDarstellungEClass, STILISIERTE_DARSTELLUNG__SPALTEN_BORDER);

		massstaeblicheDarstellungEClass = createEClass(MASSSTAEBLICHE_DARSTELLUNG);
		createEAttribute(massstaeblicheDarstellungEClass, MASSSTAEBLICHE_DARSTELLUNG__MAXIMALE_GEOGRAPHISCHE_BREITE);
		createEAttribute(massstaeblicheDarstellungEClass, MASSSTAEBLICHE_DARSTELLUNG__MINIMALE_GEOGRAPHISCHE_BREITE);
		createEAttribute(massstaeblicheDarstellungEClass, MASSSTAEBLICHE_DARSTELLUNG__MAXIMALE_GEOGRAPHISCHE_LAENGE);
		createEAttribute(massstaeblicheDarstellungEClass, MASSSTAEBLICHE_DARSTELLUNG__MINIMALE_GEOGRAPHISCHE_LAENGE);

		ebeneEClass = createEClass(EBENE);
		createEAttribute(ebeneEClass, EBENE__VISIBLE);
		createEReference(ebeneEClass, EBENE__DARSTELLUNG);
		createEReference(ebeneEClass, EBENE__DO_OBJEKTE);
		createEAttribute(ebeneEClass, EBENE__HINTERGRUND);
		createEAttribute(ebeneEClass, EBENE__HINTERGRUND_SKALIERUNG);
		createEAttribute(ebeneEClass, EBENE__HINTERGRUND_LOCATION);
		createEAttribute(ebeneEClass, EBENE__EDITABLE);
		createEAttribute(ebeneEClass, EBENE__AUSBLENDBAR);

		darstellungsSpalteEClass = createEClass(DARSTELLUNGS_SPALTE);
		createEAttribute(darstellungsSpalteEClass, DARSTELLUNGS_SPALTE__VISIBLE);
		createEAttribute(darstellungsSpalteEClass, DARSTELLUNGS_SPALTE__WIDTH);
		createEReference(darstellungsSpalteEClass, DARSTELLUNGS_SPALTE__DO_OBJEKTE);
		createEReference(darstellungsSpalteEClass, DARSTELLUNGS_SPALTE__DARSTELLUNG);

		autoEbeneEClass = createEClass(AUTO_EBENE);
		createEAttribute(autoEbeneEClass, AUTO_EBENE__SYSTEM_OBJECT_TYPES);
		createEAttribute(autoEbeneEClass, AUTO_EBENE__CONFIGURATION_AREAS);
		createEAttribute(autoEbeneEClass, AUTO_EBENE__SYSTEM_OBJECTS);
		createEAttribute(autoEbeneEClass, AUTO_EBENE__MUTABLE_SETS);
		createEReference(autoEbeneEClass, AUTO_EBENE__DO_TYPEN);
		createEReference(autoEbeneEClass, AUTO_EBENE__AUTO_DO_OBJEKTE);
		createEAttribute(autoEbeneEClass, AUTO_EBENE__SYSTEM_OBJECTS_EXCLUDES);

		ausschnittEClass = createEClass(AUSSCHNITT);
		createEAttribute(ausschnittEClass, AUSSCHNITT__BOUNDS);
		createEAttribute(ausschnittEClass, AUSSCHNITT__ZOOM_LEVEL);

		// Create enums
		anzeigeVerfahrenEEnum = createEEnum(ANZEIGE_VERFAHREN);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model. This
	 * method is guarded to have no affect on any invocation but its first. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized)
			return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		EclipsePackage theEclipsePackage = (EclipsePackage) EPackage.Registry.INSTANCE
				.getEPackage(EclipsePackage.eNS_URI);
		GefPackage theGefPackage = (GefPackage) EPackage.Registry.INSTANCE.getEPackage(GefPackage.eNS_URI);
		DobjPackage theDobjPackage = (DobjPackage) EPackage.Registry.INSTANCE.getEPackage(DobjPackage.eNS_URI);
		DavbitctrlPackage theDavbitctrlPackage = (DavbitctrlPackage) EPackage.Registry.INSTANCE
				.getEPackage(DavbitctrlPackage.eNS_URI);
		DobjDecoratorPackage theDobjDecoratorPackage = (DobjDecoratorPackage) EPackage.Registry.INSTANCE
				.getEPackage(DobjDecoratorPackage.eNS_URI);
		DavPackage theDavPackage = (DavPackage) EPackage.Registry.INSTANCE.getEPackage(DavPackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		darstellungEClass.getESuperTypes().add(theEclipsePackage.getNamed());
		darstellungEClass.getESuperTypes().add(theGefPackage.getSized());
		ansichtEClass.getESuperTypes().add(theEclipsePackage.getNamed());
		stilisierteDarstellungEClass.getESuperTypes().add(this.getDarstellung());
		massstaeblicheDarstellungEClass.getESuperTypes().add(this.getDarstellung());
		ebeneEClass.getESuperTypes().add(theEclipsePackage.getNamed());
		darstellungsSpalteEClass.getESuperTypes().add(theEclipsePackage.getNamed());
		autoEbeneEClass.getESuperTypes().add(this.getEbene());
		ausschnittEClass.getESuperTypes().add(theEclipsePackage.getNamed());

		// Initialize classes and features; add operations and parameters
		initEClass(darstellungEClass, Darstellung.class, "Darstellung", IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEReference(getDarstellung_DoTypen(), theDobjPackage.getDoTyp(), null, "doTypen", null, 0, -1,
				Darstellung.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES,
				!IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getDarstellung_Ebenen(), this.getEbene(), this.getEbene_Darstellung(), "ebenen", null, 1, -1,
				Darstellung.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES,
				!IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getDarstellung_Netz(), theDavbitctrlPackage.getNetz(), "netz", null, 0, 1, Darstellung.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getDarstellung_ZoomSkalierung(), ecorePackage.getEDouble(), "zoomSkalierung", "1.0", 0, 1,
				Darstellung.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEAttribute(getDarstellung_ZoomStufen(), ecorePackage.getEDouble(), "zoomStufen", null, 1, -1,
				Darstellung.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		EGenericType g1 = createEGenericType(theEclipsePackage.getTupel());
		EGenericType g2 = createEGenericType(ecorePackage.getEObject());
		g1.getETypeArguments().add(g2);
		g2 = createEGenericType(ecorePackage.getEObject());
		g1.getETypeArguments().add(g2);
		initEReference(getDarstellung_Properties(), g1, null, "properties", null, 0, -1, Darstellung.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE,
				IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getDarstellung_VerbindungslinieFarbe(), theEclipsePackage.getRGB(), "verbindungslinieFarbe",
				"192,192,192", 0, 1, Darstellung.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE,
				!IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getDarstellung_VerbindungslinieStaerke(), ecorePackage.getEInt(), "verbindungslinieStaerke", "1",
				0, 1, Darstellung.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEAttribute(getDarstellung_VerbindungslinieStil(), theDobjDecoratorPackage.getLinienStyle(),
				"verbindungslinieStil", "Durchgezogen", 0, 1, Darstellung.class, !IS_TRANSIENT, !IS_VOLATILE,
				IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getDarstellung_Stoerfallverfahren(), ecorePackage.getEString(), "stoerfallverfahren",
				"unbekannt", 0, 1, Darstellung.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE,
				!IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getDarstellung_AnzeigeVerfahren(), this.getAnzeigeVerfahren(), "anzeigeVerfahren", "Verfahren I",
				0, 1, Darstellung.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);

		addEOperation(darstellungEClass, this.getEbene(), "createEbene", 0, 1, IS_UNIQUE, IS_ORDERED);

		initEClass(ansichtEClass, Ansicht.class, "Ansicht", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getAnsicht_Ausschnitt(), this.getAusschnitt(), null, "ausschnitt", null, 0, 1, Ansicht.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE,
				IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAnsicht_Darstellung(), this.getDarstellung(), null, "darstellung", null, 1, 1, Ansicht.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE,
				IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAnsicht_Ausschnitte(), this.getAusschnitt(), null, "ausschnitte", null, 0, -1, Ansicht.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE,
				IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(stilisierteDarstellungEClass, StilisierteDarstellung.class, "StilisierteDarstellung", !IS_ABSTRACT,
				!IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getStilisierteDarstellung_Spalten(), this.getDarstellungsSpalte(),
				this.getDarstellungsSpalte_Darstellung(), "spalten", null, 0, -1, StilisierteDarstellung.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE,
				IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getStilisierteDarstellung_SpaltenBorder(), ecorePackage.getEBoolean(), "spaltenBorder", "false",
				0, 1, StilisierteDarstellung.class, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID,
				IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(massstaeblicheDarstellungEClass, MassstaeblicheDarstellung.class, "MassstaeblicheDarstellung",
				!IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getMassstaeblicheDarstellung_MaximaleGeographischeBreite(), ecorePackage.getEDouble(),
				"maximaleGeographischeBreite", "55.1", 0, 1, MassstaeblicheDarstellung.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMassstaeblicheDarstellung_MinimaleGeographischeBreite(), ecorePackage.getEDouble(),
				"minimaleGeographischeBreite", "47.1", 0, 1, MassstaeblicheDarstellung.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMassstaeblicheDarstellung_MaximaleGeographischeLaenge(), ecorePackage.getEDouble(),
				"maximaleGeographischeLaenge", "15.1", 0, 1, MassstaeblicheDarstellung.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getMassstaeblicheDarstellung_MinimaleGeographischeLaenge(), ecorePackage.getEDouble(),
				"minimaleGeographischeLaenge", "5.8", 0, 1, MassstaeblicheDarstellung.class, !IS_TRANSIENT,
				!IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(ebeneEClass, Ebene.class, "Ebene", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getEbene_Visible(), ecorePackage.getEBoolean(), "visible", "true", 0, 1, Ebene.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getEbene_Darstellung(), this.getDarstellung(), this.getDarstellung_Ebenen(), "darstellung", null,
				1, 1, Ebene.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES,
				!IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getEbene_DoObjekte(), theDobjPackage.getDoModel(), null, "doObjekte", null, 0, -1, Ebene.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE,
				IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getEbene_Hintergrund(), theDavbitctrlPackage.getBild(), "hintergrund", null, 0, 1, Ebene.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getEbene_HintergrundSkalierung(), ecorePackage.getEDouble(), "hintergrundSkalierung", "1.0", 0,
				1, Ebene.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEAttribute(getEbene_HintergrundLocation(), theGefPackage.getPoint(), "hintergrundLocation", null, 0, 1,
				Ebene.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED,
				IS_ORDERED);
		initEAttribute(getEbene_Editable(), ecorePackage.getEBoolean(), "editable", "false", 0, 1, Ebene.class,
				IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getEbene_Ausblendbar(), ecorePackage.getEBoolean(), "ausblendbar", "true", 0, 1, Ebene.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(darstellungsSpalteEClass, DarstellungsSpalte.class, "DarstellungsSpalte", !IS_ABSTRACT,
				!IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getDarstellungsSpalte_Visible(), ecorePackage.getEBoolean(), "visible", "true", 0, 1,
				DarstellungsSpalte.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEAttribute(getDarstellungsSpalte_Width(), ecorePackage.getEInt(), "width", "250", 0, 1,
				DarstellungsSpalte.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEReference(getDarstellungsSpalte_DoObjekte(), theDobjPackage.getDoModel(), null, "doObjekte", null, 0, -1,
				DarstellungsSpalte.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES,
				!IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getDarstellungsSpalte_Darstellung(), this.getStilisierteDarstellung(),
				this.getStilisierteDarstellung_Spalten(), "darstellung", null, 1, 1, DarstellungsSpalte.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE,
				IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(autoEbeneEClass, AutoEbene.class, "AutoEbene", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getAutoEbene_SystemObjectTypes(), theDavPackage.getSystemObjectType(), "systemObjectTypes", null,
				0, -1, AutoEbene.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEAttribute(getAutoEbene_ConfigurationAreas(), theDavPackage.getConfigurationArea(), "configurationAreas",
				null, 0, -1, AutoEbene.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID,
				IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAutoEbene_SystemObjects(), theDavPackage.getSystemObject(), "systemObjects", null, 0, -1,
				AutoEbene.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEAttribute(getAutoEbene_MutableSets(), theDavPackage.getMutableSet(), "mutableSets", null, 0, -1,
				AutoEbene.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
				!IS_DERIVED, IS_ORDERED);
		initEReference(getAutoEbene_DoTypen(), theDobjPackage.getDoTyp(), null, "doTypen", null, 0, -1, AutoEbene.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE,
				IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAutoEbene_AutoDoObjekte(), theDobjPackage.getDoModel(), null, "autoDoObjekte", null, 0, -1,
				AutoEbene.class, IS_TRANSIENT, !IS_VOLATILE, !IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES,
				!IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAutoEbene_SystemObjectsExcludes(), theDavPackage.getSystemObject(), "systemObjectsExcludes",
				null, 0, -1, AutoEbene.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID,
				IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		EOperation op = addEOperation(autoEbeneEClass, ecorePackage.getEBoolean(), "isAutomatischVerwaltbar", 0, 1,
				IS_UNIQUE, IS_ORDERED);
		addEParameter(op, theDobjPackage.getDoModel(), "modellObjekt", 0, 1, IS_UNIQUE, IS_ORDERED);

		op = addEOperation(autoEbeneEClass, ecorePackage.getEBoolean(), "isAutomatischVerwaltet", 0, 1, IS_UNIQUE,
				IS_ORDERED);
		addEParameter(op, theDobjPackage.getDoModel(), "modellObjekt", 0, 1, IS_UNIQUE, IS_ORDERED);

		initEClass(ausschnittEClass, Ausschnitt.class, "Ausschnitt", !IS_ABSTRACT, !IS_INTERFACE,
				IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getAusschnitt_Bounds(), theGefPackage.getRectangle(), "bounds", null, 0, 1, Ausschnitt.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAusschnitt_ZoomLevel(), ecorePackage.getEDouble(), "zoomLevel", "1", 0, 1, Ausschnitt.class,
				!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Initialize enums and add enum literals
		initEEnum(anzeigeVerfahrenEEnum, AnzeigeVerfahren.class, "AnzeigeVerfahren");
		addEEnumLiteral(anzeigeVerfahrenEEnum, AnzeigeVerfahren.VERFAHREN_I);
		addEEnumLiteral(anzeigeVerfahrenEEnum, AnzeigeVerfahren.VERFAHREN_II);
		addEEnumLiteral(anzeigeVerfahrenEEnum, AnzeigeVerfahren.VERFAHREN_III);

		// Create resource
		createResource(eNS_URI);
	}

} // DarstellungPackageImpl
