/**
 * Darstellungsobjekte
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 *
 * $Id$
 */
package de.bsvrz.buv.plugin.darstellung.model.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;

import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte;
import de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Stilisierte Darstellung</b></em>'.<!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.StilisierteDarstellungImpl#getSpalten <em>Spalten</em>}</li>
 *   <li>{@link de.bsvrz.buv.plugin.darstellung.model.impl.StilisierteDarstellungImpl#isSpaltenBorder <em>Spalten Border</em>}</li>
 * </ul>
 *
 * @generated
 */
public class StilisierteDarstellungImpl extends DarstellungImpl implements StilisierteDarstellung {
	/**
	 * The cached value of the '{@link #getSpalten() <em>Spalten</em>}' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @see #getSpalten()
	 * @generated
	 * @ordered
	 */
	protected EList<DarstellungsSpalte> spalten;

	/**
	 * The default value of the '{@link #isSpaltenBorder() <em>Spalten Border</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #isSpaltenBorder()
	 * @generated
	 * @ordered
	 */
	protected static final boolean SPALTEN_BORDER_EDEFAULT = false;
	/**
	 * The cached value of the '{@link #isSpaltenBorder() <em>Spalten Border</em>}' attribute.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @see #isSpaltenBorder()
	 * @generated
	 * @ordered
	 */
	protected boolean spaltenBorder = SPALTEN_BORDER_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected StilisierteDarstellungImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DarstellungPackage.Literals.STILISIERTE_DARSTELLUNG;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<DarstellungsSpalte> getSpalten() {
		if (spalten == null) {
			spalten = new EObjectContainmentWithInverseEList<DarstellungsSpalte>(DarstellungsSpalte.class, this,
					DarstellungPackage.STILISIERTE_DARSTELLUNG__SPALTEN,
					DarstellungPackage.DARSTELLUNGS_SPALTE__DARSTELLUNG);
		}
		return spalten;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSpaltenBorder() {
		return spaltenBorder;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSpaltenBorder(boolean newSpaltenBorder) {
		boolean oldSpaltenBorder = spaltenBorder;
		spaltenBorder = newSpaltenBorder;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DarstellungPackage.STILISIERTE_DARSTELLUNG__SPALTEN_BORDER, oldSpaltenBorder, spaltenBorder));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DarstellungPackage.STILISIERTE_DARSTELLUNG__SPALTEN:
			return ((InternalEList<InternalEObject>) (InternalEList<?>) getSpalten()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DarstellungPackage.STILISIERTE_DARSTELLUNG__SPALTEN:
			return ((InternalEList<?>) getSpalten()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DarstellungPackage.STILISIERTE_DARSTELLUNG__SPALTEN:
			return getSpalten();
		case DarstellungPackage.STILISIERTE_DARSTELLUNG__SPALTEN_BORDER:
			return isSpaltenBorder();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DarstellungPackage.STILISIERTE_DARSTELLUNG__SPALTEN:
			getSpalten().clear();
			getSpalten().addAll((Collection<? extends DarstellungsSpalte>) newValue);
			return;
		case DarstellungPackage.STILISIERTE_DARSTELLUNG__SPALTEN_BORDER:
			setSpaltenBorder((Boolean) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DarstellungPackage.STILISIERTE_DARSTELLUNG__SPALTEN:
			getSpalten().clear();
			return;
		case DarstellungPackage.STILISIERTE_DARSTELLUNG__SPALTEN_BORDER:
			setSpaltenBorder(SPALTEN_BORDER_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DarstellungPackage.STILISIERTE_DARSTELLUNG__SPALTEN:
			return spalten != null && !spalten.isEmpty();
		case DarstellungPackage.STILISIERTE_DARSTELLUNG__SPALTEN_BORDER:
			return spaltenBorder != SPALTEN_BORDER_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (spaltenBorder: ");
		result.append(spaltenBorder);
		result.append(')');
		return result.toString();
	}

} // StilisierteDarstellungImpl
