/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.model.provider;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

import de.bsvrz.buv.plugin.darstellung.model.AutoEbene;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;

/**
 * This is the item provider adapter for a
 * {@link de.bsvrz.buv.plugin.darstellung.model.AutoEbene} object. <!--
 * begin-user-doc --> <!-- end-user-doc -->
 *
 * @generated
 */
public class AutoEbeneItemProvider extends EbeneItemProvider {
	/**
	 * This constructs an instance from a factory and a notifier. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public AutoEbeneItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addSystemObjectTypesPropertyDescriptor(object);
			addConfigurationAreasPropertyDescriptor(object);
			addSystemObjectsPropertyDescriptor(object);
			addMutableSetsPropertyDescriptor(object);
			addDoTypenPropertyDescriptor(object);
			addAutoDoObjektePropertyDescriptor(object);
			addSystemObjectsExcludesPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the System Object Types feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected void addSystemObjectTypesPropertyDescriptor(Object object) {
		itemPropertyDescriptors
				.add(createItemPropertyDescriptor(((ComposeableAdapterFactory) adapterFactory).getRootAdapterFactory(),
						getResourceLocator(), getString("_UI_AutoEbene_systemObjectTypes_feature"),
						getString("_UI_PropertyDescriptor_description", "_UI_AutoEbene_systemObjectTypes_feature",
								"_UI_AutoEbene_type"),
						DarstellungPackage.Literals.AUTO_EBENE__SYSTEM_OBJECT_TYPES, true, false, false,
						ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Configuration Areas feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected void addConfigurationAreasPropertyDescriptor(Object object) {
		itemPropertyDescriptors
				.add(createItemPropertyDescriptor(((ComposeableAdapterFactory) adapterFactory).getRootAdapterFactory(),
						getResourceLocator(), getString("_UI_AutoEbene_configurationAreas_feature"),
						getString("_UI_PropertyDescriptor_description", "_UI_AutoEbene_configurationAreas_feature",
								"_UI_AutoEbene_type"),
						DarstellungPackage.Literals.AUTO_EBENE__CONFIGURATION_AREAS, true, false, false,
						ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the System Objects feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected void addSystemObjectsPropertyDescriptor(Object object) {
		itemPropertyDescriptors
				.add(createItemPropertyDescriptor(((ComposeableAdapterFactory) adapterFactory).getRootAdapterFactory(),
						getResourceLocator(), getString("_UI_AutoEbene_systemObjects_feature"),
						getString("_UI_PropertyDescriptor_description", "_UI_AutoEbene_systemObjects_feature",
								"_UI_AutoEbene_type"),
						DarstellungPackage.Literals.AUTO_EBENE__SYSTEM_OBJECTS, true, false, false,
						ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Mutable Sets feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected void addMutableSetsPropertyDescriptor(Object object) {
		itemPropertyDescriptors
				.add(createItemPropertyDescriptor(((ComposeableAdapterFactory) adapterFactory).getRootAdapterFactory(),
						getResourceLocator(), getString("_UI_AutoEbene_mutableSets_feature"),
						getString("_UI_PropertyDescriptor_description", "_UI_AutoEbene_mutableSets_feature",
								"_UI_AutoEbene_type"),
						DarstellungPackage.Literals.AUTO_EBENE__MUTABLE_SETS, true, false, false,
						ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Do Typen feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected void addDoTypenPropertyDescriptor(Object object) {
		itemPropertyDescriptors
				.add(createItemPropertyDescriptor(((ComposeableAdapterFactory) adapterFactory).getRootAdapterFactory(),
						getResourceLocator(), getString("_UI_AutoEbene_doTypen_feature"),
						getString("_UI_PropertyDescriptor_description", "_UI_AutoEbene_doTypen_feature",
								"_UI_AutoEbene_type"),
						DarstellungPackage.Literals.AUTO_EBENE__DO_TYPEN, true, false, true, null, null, null));
	}

	/**
	 * This adds a property descriptor for the Auto Do Objekte feature. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected void addAutoDoObjektePropertyDescriptor(Object object) {
		itemPropertyDescriptors
				.add(createItemPropertyDescriptor(((ComposeableAdapterFactory) adapterFactory).getRootAdapterFactory(),
						getResourceLocator(), getString("_UI_AutoEbene_autoDoObjekte_feature"),
						getString("_UI_PropertyDescriptor_description", "_UI_AutoEbene_autoDoObjekte_feature",
								"_UI_AutoEbene_type"),
						DarstellungPackage.Literals.AUTO_EBENE__AUTO_DO_OBJEKTE, false, false, false, null, null,
						null));
	}

	/**
	 * This adds a property descriptor for the System Objects Excludes feature.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addSystemObjectsExcludesPropertyDescriptor(Object object) {
		itemPropertyDescriptors
				.add(createItemPropertyDescriptor(((ComposeableAdapterFactory) adapterFactory).getRootAdapterFactory(),
						getResourceLocator(), getString("_UI_AutoEbene_systemObjectsExcludes_feature"),
						getString("_UI_PropertyDescriptor_description", "_UI_AutoEbene_systemObjectsExcludes_feature",
								"_UI_AutoEbene_type"),
						DarstellungPackage.Literals.AUTO_EBENE__SYSTEM_OBJECTS_EXCLUDES, true, false, false,
						ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
	}

	/**
	 * This returns AutoEbene.gif. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object getImage(Object object) {
		return overlayImage(object, getResourceLocator().getImage("full/obj16/AutoEbene"));
	}

	/**
	 * This returns the label text for the adapted class. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String getText(Object object) {
		final String label = ((AutoEbene) object).getName();
		return label == null || label.length() == 0 ? getString("_UI_AutoEbene_type")
				: getString("_UI_AutoEbene_type") + " " + label;
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to
	 * update any cached children and by creating a viewer notification, which
	 * it passes to {@link #fireNotifyChanged}. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(AutoEbene.class)) {
		case DarstellungPackage.AUTO_EBENE__SYSTEM_OBJECT_TYPES:
		case DarstellungPackage.AUTO_EBENE__CONFIGURATION_AREAS:
		case DarstellungPackage.AUTO_EBENE__SYSTEM_OBJECTS:
		case DarstellungPackage.AUTO_EBENE__MUTABLE_SETS:
		case DarstellungPackage.AUTO_EBENE__SYSTEM_OBJECTS_EXCLUDES:
			fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), false, true));
			return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing the children that can be created under this object. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);
	}

}
