/**
 * Darstellungsobjekte
 * Copyright (C) 2010 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * 
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.model.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import de.bsvrz.buv.plugin.darstellung.model.util.DarstellungAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc --> <!--
 * end-user-doc -->
 * @generated
 */
public class DarstellungItemProviderAdapterFactory extends DarstellungAdapterFactory
		implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement
	 * {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @generated
	 */
	public DarstellungItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.darstellung.model.Ansicht} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected AnsichtItemProvider ansichtItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.darstellung.model.Ansicht}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createAnsichtAdapter() {
		if (ansichtItemProvider == null) {
			ansichtItemProvider = new AnsichtItemProvider(this);
		}

		return ansichtItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected StilisierteDarstellungItemProvider stilisierteDarstellungItemProvider;

	/**
	 * This creates an adapter for a {@link de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStilisierteDarstellungAdapter() {
		if (stilisierteDarstellungItemProvider == null) {
			stilisierteDarstellungItemProvider = new StilisierteDarstellungItemProvider(this);
		}

		return stilisierteDarstellungItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected MassstaeblicheDarstellungItemProvider massstaeblicheDarstellungItemProvider;

	/**
	 * This creates an adapter for a {@link de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMassstaeblicheDarstellungAdapter() {
		if (massstaeblicheDarstellungItemProvider == null) {
			massstaeblicheDarstellungItemProvider = new MassstaeblicheDarstellungItemProvider(this);
		}

		return massstaeblicheDarstellungItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.darstellung.model.Ebene} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected EbeneItemProvider ebeneItemProvider;

	/**
	 * This creates an adapter for a {@link de.bsvrz.buv.plugin.darstellung.model.Ebene}.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEbeneAdapter() {
		if (ebeneItemProvider == null) {
			ebeneItemProvider = new EbeneItemProvider(this);
		}

		return ebeneItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte} instances.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected DarstellungsSpalteItemProvider darstellungsSpalteItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createDarstellungsSpalteAdapter() {
		if (darstellungsSpalteItemProvider == null) {
			darstellungsSpalteItemProvider = new DarstellungsSpalteItemProvider(this);
		}

		return darstellungsSpalteItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.darstellung.model.AutoEbene} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected AutoEbeneItemProvider autoEbeneItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.darstellung.model.AutoEbene}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createAutoEbeneAdapter() {
		if (autoEbeneItemProvider == null) {
			autoEbeneItemProvider = new AutoEbeneItemProvider(this);
		}

		return autoEbeneItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all
	 * {@link de.bsvrz.buv.plugin.darstellung.model.Ausschnitt} instances. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected AusschnittItemProvider ausschnittItemProvider;

	/**
	 * This creates an adapter for a
	 * {@link de.bsvrz.buv.plugin.darstellung.model.Ausschnitt}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createAusschnittAdapter() {
		if (ausschnittItemProvider == null) {
			ausschnittItemProvider = new AusschnittItemProvider(this);
		}

		return ausschnittItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to
	 * {@link #parentAdapterFactory}. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void dispose() {
		if (ansichtItemProvider != null)
			ansichtItemProvider.dispose();
		if (stilisierteDarstellungItemProvider != null)
			stilisierteDarstellungItemProvider.dispose();
		if (massstaeblicheDarstellungItemProvider != null)
			massstaeblicheDarstellungItemProvider.dispose();
		if (ebeneItemProvider != null)
			ebeneItemProvider.dispose();
		if (darstellungsSpalteItemProvider != null)
			darstellungsSpalteItemProvider.dispose();
		if (autoEbeneItemProvider != null)
			autoEbeneItemProvider.dispose();
		if (ausschnittItemProvider != null)
			ausschnittItemProvider.dispose();
	}

}
