/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.util;

import org.eclipse.jface.resource.ImageDescriptor;

import de.bsvrz.buv.plugin.dobj.internal.DObjPlugin;

/**
 * Stellt gemeinsam nutzbare Icons zur Verfügung.
 *
 * @author BitCtrl Systems GmbH, Schumann
 *
 */
public enum DarstellungIcons {

	// Icons für Actions (actions)

	/** Schaltfläche zum Anlegen eines neuen Ausschnitts. */
	ActionAusschnittAnlegen("icons/16x16/actions/ausschnitt-anlegen.png"),

	/** Schaltfläche zum Synchronisieren der Selection von Workbench Parts. */
	ActionSelectionLink("icons/16x16/actions/selection-link.gif"),

	/** Schaltfläche zum Ein-/Ausblenden des Ebenenmanagers. */
	ActionToggleEbenen("icons/16x16/actions/toggle-ebenen.gif"),

	/** Schaltfläche zum Ein-/Ausblenden der Übersicht. */
	ActionToggleOverview("icons/16x16/actions/toggle-overview.gif"),

	/** Schaltfläche zum Wählen eines Ausschnitss. */
	ActionSelectAusschnitt("icons/16x16/actions/ausschnitt-waehlen.png"),

	/**
	 * Schaltfläche zum Ausführen der globalen Aktion zum Anpassen der
	 * Ansichten.
	 */
	ActionEditAnsichten("icons/16x16/actions/ansichten-edit.png"),

	/** Schaltfläche für den Selektionsfilter. */
	ActionSelectionFilter("icons/16x16/actions/selection-filter.gif"),

	/** Schaltfläche für den Selektionsfilter. */
	ActionEditEbene("icons/16x16/actions/ebene-edit.png"),

	// Icons für Kategorien (categories)

	/** Icon für einen Systemobjekttyp. */
	CategorySystemObjektTyp("icons/16x16/categories/systemobjekttyp.png"),

	/** Icon für einen Konfigurationsbereich. */
	CategoryKonfigurationsbereich("icons/16x16/categories/konfigurationsbereich.png"),

	/** Icon für eine dynamische Menge. */
	CategoryDynamischeMenge("icons/16x16/categories/dynamischemenge.png"),

	/** Icon für ein Systemobjekt. */
	CategorySystemObjekt("icons/16x16/categories/systemobjekt.png"),

	// Icons für Statuswerte (status)

	/** Status für eine sichtare Ebene. */
	StatusEbeneVisible("icons/16x16/status/ebene-visible.gif"),

	/** Status für eine ausgeblendete Ebene. */
	StatusEbeneInvisible("icons/16x16/status/ebene-invisible.gif"),

	// Icons für Objekt(typen)

	/** Typ-Icon für <em>Ansicht</em>. */
	Ansicht("icons/full/obj16/Ansicht.gif"),

	/** Typ-Icon für <em>Ansicht</em>. */
	Ausschnitt("icons/full/obj16/Ausschnitt.gif"),

	/** Typ-Icon für <em>Ansicht</em>. */
	StilisierteDarstellung("icons/full/obj16/StilisierteDarstellung.gif"),

	/** Typ-Icon für <em>Ansicht</em>. */
	MassstaeblicheDarstellung("icons/full/obj16/MassstaeblicheDarstellung.gif"),

	/** Typ-Icon für <em>Ansicht</em>. */
	Ebene("icons/full/obj16/Ebene.gif"),

	/** Typ-Icon für <em>Ansicht</em>. */
	DarstellungsSpalte("icons/full/obj16/DarstellungsSpalte.gif"),

	;

	private final ImageDescriptor imageDescriptor;

	private DarstellungIcons(final String imagePath) {
		imageDescriptor = DObjPlugin.getDefault().getImageDescriptor(imagePath);
		if (imageDescriptor == null) {
			final String message = "Datei nicht gefunden: " + imagePath;
			DObjPlugin.getDefault().getLogger().error(message);
		}
	}

	/**
	 * Gibt den {@link ImageDescriptor} zurück.
	 */
	public ImageDescriptor getImageDescriptor() {
		return imageDescriptor;
	}

}
