/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.views;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

import de.bsvrz.buv.plugin.darstellung.actions.ZeigeAnsichtAction;
import de.bsvrz.buv.plugin.darstellung.model.Ansicht;
import de.bsvrz.buv.plugin.darstellung.util.AnsichtenEinstellungen;
import de.bsvrz.buv.plugin.dobj.internal.DObjPlugin;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.AbstractEinstellungenView;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.ModellEinstellungen;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf.CopyEinstellungAction;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf.DeleteEinstellungAction;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf.MoveEinstellungAction;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf.RenameEinstellungAction;

/**
 * View zum Verwalten der im System vorhandenen {@link Ansicht}en.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class AnsichtenView extends AbstractEinstellungenView implements PropertyChangeListener {

	/** die Kontext-Hilfe-ID. */
	public static final String HILFE_ID = DObjPlugin.PLUGIN_ID + ".AnsichtenAllgemein";

	/** Die ID der View. */
	public static final String VIEW_ID = AnsichtenView.class.getName();

	@Override
	public void init(final IViewSite site) throws PartInitException {
		super.init(site);

		site.getActionBars().setGlobalActionHandler(ActionFactory.RENAME.getCommandId(),
				new RenameEinstellungAction<>(this, AnsichtenEinstellungen.INSTANCE));
		site.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getCommandId(),
				new CopyEinstellungAction<>(this, AnsichtenEinstellungen.INSTANCE));
		site.getActionBars().setGlobalActionHandler(ActionFactory.MOVE.getCommandId(),
				new MoveEinstellungAction<>(this, AnsichtenEinstellungen.INSTANCE));
		site.getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getCommandId(),
				new DeleteEinstellungAction<>(this, AnsichtenEinstellungen.INSTANCE));
	}

	@Override
	protected void configureViewer(final TreeViewer treeViewer) {
		treeViewer.setInput(AnsichtenEinstellungen.INSTANCE);

		AnsichtenEinstellungen.INSTANCE.addPropertyChangeListener(this);

		PlatformUI.getWorkbench().getHelpSystem().setHelp(treeViewer.getControl(), AnsichtenView.HILFE_ID);
	}

	@Override
	public void propertyChange(final PropertyChangeEvent evt) {
		final String prop = evt.getPropertyName();

		if (ModellEinstellungen.PROP_EINSTELLUNG_CHANGED.equals(prop)) {
			PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable() {

				@Override
				public void run() {
					final StructuredViewer v = getViewer();
					if (!v.getControl().isDisposed()) {
						v.refresh();
					}
				}

			});
		}
	}

	@Override
	protected void doDoubleClick(final DoubleClickEvent event) {
		new ZeigeAnsichtAction(this).run();
	}

	@Override
	public void dispose() {
		AnsichtenEinstellungen.INSTANCE.removePropertyChangeListener(this);
		super.dispose();
	}

}
