/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.views;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.handlers.IHandlerService;

import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungenEinstellungen;
import de.bsvrz.buv.plugin.dobj.internal.DObjPlugin;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.AbstractEinstellungenView;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.ModellEinstellungen;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf.CopyEinstellungAction;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf.DeleteEinstellungAction;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf.MoveEinstellungAction;
import de.bsvrz.buv.rw.bitctrl.eclipse.modell.emf.RenameEinstellungAction;

/**
 * View zum Verwalten der im System vorhandenen {@link Darstellung}en.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class DarstellungenView extends AbstractEinstellungenView implements PropertyChangeListener {

	/** Die ID der View. */
	public static final String VIEW_ID = DarstellungenView.class.getName();

	@Override
	public void init(final IViewSite site) throws PartInitException {
		super.init(site);

		site.getActionBars().setGlobalActionHandler(ActionFactory.RENAME.getCommandId(),
				new RenameEinstellungAction<>(this, DarstellungenEinstellungen.INSTANCE));
		site.getActionBars().setGlobalActionHandler(ActionFactory.MOVE.getCommandId(),
				new MoveEinstellungAction<>(this, DarstellungenEinstellungen.INSTANCE));
		site.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getCommandId(),
				new CopyEinstellungAction<>(this, DarstellungenEinstellungen.INSTANCE));
		site.getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getCommandId(),
				new DeleteEinstellungAction<>(this, DarstellungenEinstellungen.INSTANCE));
	}

	@Override
	protected void configureViewer(final TreeViewer treeViewer) {
		treeViewer.setInput(DarstellungenEinstellungen.INSTANCE);

		DarstellungenEinstellungen.INSTANCE.addPropertyChangeListener(this);

		PlatformUI.getWorkbench().getHelpSystem().setHelp(treeViewer.getControl(), AnsichtenView.HILFE_ID);
	}

	@Override
	protected void doDoubleClick(final DoubleClickEvent event) {
		final IHandlerService handlerService = getSite().getService(IHandlerService.class);
		try {
			handlerService.executeCommand("de.bsvrz.buv.plugin.dopositionierer.command.bearbeiteDarstellung", null);
		} catch (final ExecutionException ex) {
			DObjPlugin.getDefault().getLogger().error("Fehler beim Ausführen des Doppelklicks in DarstellungenView",
					ex);
		} catch (final NotDefinedException ex) {
			/*
			 * wird ignoriert, weil Vorpositionier in dem Fall einfach nicht
			 * installiert ist.
			 */
		} catch (final NotEnabledException ex) {
			/*
			 * wird ignoriert, weil Vorpositionier in dem Fall einfach nicht
			 * installiert ist.
			 */
		} catch (final NotHandledException ex) {
			/*
			 * wird ignoriert, weil Vorpositionier in dem Fall einfach nicht
			 * installiert ist.
			 */
		}
	}

	@Override
	public void propertyChange(final PropertyChangeEvent evt) {
		final String prop = evt.getPropertyName();

		if (ModellEinstellungen.PROP_EINSTELLUNG_CHANGED.equals(prop)) {
			PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable() {

				@Override
				public void run() {
					if (!getViewer().getControl().isDisposed()) {
						getViewer().refresh();
					}
				}
			});
		}
	}

	@Override
	public void dispose() {
		DarstellungenEinstellungen.INSTANCE.removePropertyChangeListener(this);
		super.dispose();
	}

}
