/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.views.ansicht;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.tools.AbstractTool;

/**
 * Mit diesem Tool kann der angezeigte Ausschnitt der Darstellung mit der Maus
 * verschoben werden.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 * @author BitCtrl Systems GmbH, Thomas Thierfelder
 */
class ViewPanTool extends AbstractTool {

	public static final String PROP_ACTIVE = "active";

	private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
	private Point startPunkt;

	ViewPanTool() {
		setDefaultCursor(Cursors.HAND);
		setUnloadWhenFinished(false);
	}

	@Override
	protected String getCommandName() {
		return "pan";
	}

	@Override
	protected boolean isViewerImportant(final EditPartViewer viewer) {
		return viewer instanceof GraphicalViewer;
	}

	@Override
	public void activate() {
		super.activate();
		propertyChangeSupport.firePropertyChange(PROP_ACTIVE, null, true);
	}

	@Override
	public void deactivate() {
		super.deactivate();
		propertyChangeSupport.firePropertyChange(PROP_ACTIVE, null, false);
	}

	@Override
	public boolean isActive() {
		return super.isActive();
	}

	@Override
	protected boolean handleButtonDown(final int button) {
		if (button == 1) {
			startPunkt = new Point(getViewport().getHorizontalRangeModel().getValue(),
					getViewport().getVerticalRangeModel().getValue());
		} else {
			handleInvalidInput();
		}
		return true;
	}

	private Viewport getViewport() {
		return getZoomManager().getViewport();
	}

	protected ZoomManager getZoomManager() {
		return (ZoomManager) getCurrentViewer().getProperty(ZoomManager.class.toString());
	}

	@Override
	protected boolean handleDragInProgress() {
		if (startPunkt != null) {
			final int divX = getStartLocation().x - getLocation().x;
			final int divY = getStartLocation().y - getLocation().y;
			getViewport().setHorizontalLocation(startPunkt.x + divX);
			getViewport().setVerticalLocation(startPunkt.y + divY);
		} else {
			handleInvalidInput();
		}

		return true;
	}

	@Override
	protected boolean handleButtonUp(final int button) {
		startPunkt = null;
		return true;
	}

	@Override
	protected boolean handleInvalidInput() {
		startPunkt = null;
		return super.handleInvalidInput();
	}

	public void addPropertyChangeListener(final PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(listener);
	}

	public void removePropertyChangeListener(final PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(listener);
	}

}
