/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.wizards;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.wizard.Wizard;

/**
 * Implementiert die gemeinsamen Eigenschaften von Import- und Export-Wizards.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public abstract class AbstractWizard extends Wizard {

	private final EClass eClass;

	/**
	 * Initialisiert den Wizard.
	 *
	 * @param eClass
	 *            die Klasse der zu exportierenden Objekte.
	 */
	protected AbstractWizard(final EClass eClass) {
		this.eClass = eClass;
	}

	/**
	 * Gibt den Typ der zu exportierenden Objekte zurück.
	 */
	protected EClass getEClass() {
		return eClass;
	}

}
