/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.wizards;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

/**
 * Implementiert die gemeinsamen Eigenschaften von Import- und Export-Wizards.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public abstract class AbstractWorkbenchWizard extends AbstractWizard implements IWorkbenchWizard {

	private IWorkbench workbench;
	private IStructuredSelection selection;

	/**
	 * Initialisiert den Wizard.
	 *
	 * @param eClass
	 *            die Klasse der zu exportierenden Objekte.
	 */
	protected AbstractWorkbenchWizard(final EClass eClass) {
		super(eClass);
	}

	@Override
	public void init(final IWorkbench w, final IStructuredSelection s) {
		workbench = w;
		selection = s;
	}

	/**
	 * Gibt die Workbench bei der Initialisierung zurück.
	 *
	 * @see #init(IWorkbench, IStructuredSelection)
	 */
	protected IWorkbench getWorkbench() {
		return workbench;
	}

	/**
	 * Gibt die Selektion bei der Initialisierung zurück.
	 *
	 * @see #init(IWorkbench, IStructuredSelection)
	 */
	protected IStructuredSelection getSelection() {
		return selection;
	}

}
