/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.wizards;

import java.io.IOException;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.INewWizard;

import de.bsvrz.buv.plugin.darstellung.model.Ansicht;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;
import de.bsvrz.buv.plugin.darstellung.util.AnsichtenEinstellungen;
import de.bsvrz.buv.plugin.dobj.internal.DObjPlugin;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.basislib.einstellungen.UrlasserDialogAbgebrochenException;
import de.bsvrz.buv.rw.bitctrl.eclipse.wizards.EinstellungsArtWizardPage;

/**
 * Wizard zum Anlegen einer neuen Ansicht.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class AnsichtNewWizard extends AbstractWorkbenchWizard implements INewWizard {

	/** Konstante für diesen Wizard. */
	public static final String WIZARD_ID = AnsichtNewWizard.class.getName();

	private AnsichtNewWizardPage ansichtPage;
	private EinstellungsArtWizardPage einstellungsArtPage;

	/**
	 * Initialisiert den Wizard.
	 */
	public AnsichtNewWizard() {
		super(DarstellungPackage.Literals.ANSICHT);
	}

	@Override
	public void addPages() {
		ansichtPage = new AnsichtNewWizardPage(AnsichtNewWizardPage.class.getName());
		addPage(ansichtPage);

		einstellungsArtPage = new EinstellungsArtWizardPage(EinstellungsArtWizardPage.class.getName());
		einstellungsArtPage.setMultiple(false);
		addPage(einstellungsArtPage);
	}

	@Override
	public boolean performFinish() {
		final Ansicht ansicht = ansichtPage.getAnsicht();
		final SpeicherKey art = einstellungsArtPage.getFirstEinstellungsArt();

		if (AnsichtenEinstellungen.INSTANCE.getModellEinstellungen(art, ansicht.getName()) != null) {
			if (MessageDialog.openQuestion(getShell(), "Ansicht  überschreiben", "Eine Ansicht mit dem Namen \""
					+ ansicht.getName() + "\" existiert bereits in den Einstellungen \"" + art
					+ "\".\n\nWollen Sie diese Ansicht überschreiben? Diese Aktion kann nicht rückgängig gemacht werden.")) {
				try {
					AnsichtenEinstellungen.INSTANCE.setModellEinstellungen(art, ansicht.getName(), ansicht);
					return true;
				} catch (final UrlasserDialogAbgebrochenException ex) {
					// Bediener hat den Urlasserdialog abgebrochen, das ist ein
					// normaler
					// Vorgang
					return false;
				} catch (final IOException ex) {
					ErrorDialog.openError(ansichtPage.getShell(), "FEHLER", "Ansicht konnte nicht angelegt werden!",
							new Status(IStatus.ERROR, DObjPlugin.PLUGIN_ID, ex.getLocalizedMessage(), ex));
					return false;
				}
			}
			return false;
		}

		try {
			AnsichtenEinstellungen.INSTANCE.setModellEinstellungen(art, ansicht.getName(), ansicht);
			return true;
		} catch (final UrlasserDialogAbgebrochenException ex) {
			// Bediener hat den Urlasserdialog abgebrochen, das ist ein
			// normaler
			// Vorgang
			return false;
		} catch (final IOException ex) {
			ErrorDialog.openError(ansichtPage.getShell(), "FEHLER", "Ansicht konnte nicht angelegt werden!",
					new Status(IStatus.ERROR, DObjPlugin.PLUGIN_ID, ex.getLocalizedMessage(), ex));
			return false;
		}
	}

}
