/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.darstellung.wizards;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.bitctrl.lib.eclipse.emf.viewers.EmfLabelProvider;

import de.bsvrz.buv.plugin.darstellung.model.Ansicht;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungFactory;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungenEinstellungen;
import de.bsvrz.buv.rw.bitctrl.eclipse.viewers.EinstellungenContentProvider;

/**
 * Wizard Page für die Einstellungen einer Ansicht (Darstellung und Ausschnitt).
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class AnsichtNewWizardPage extends WizardPage implements ModifyListener, ISelectionChangedListener {

	private Text name;
	private TreeViewer darstellung;

	/**
	 * Initialisiert die Wizard Page.
	 */
	public AnsichtNewWizardPage(final String pageName) {
		super(pageName);
		setTitle("Neue Ansicht");
		setDescription("Bitte geben Sie den Namen der neuen Ansicht und die zu verwendende Darstellung an.");
		setPageComplete(false);
	}

	@Override
	public void createControl(final Composite parent) {
		final Composite container = new Composite(parent, SWT.NONE);
		container.setLayout(new GridLayout(2, false));

		createName(container);
		createDarstellung(container);

		name.setFocus();
		setControl(container);
	}

	private void createName(final Composite parent) {
		final Label label = new Label(parent, SWT.NONE);
		label.setText("Name");
		name = new Text(parent, SWT.BORDER);
		name.setLayoutData(GridDataFactory.swtDefaults().align(SWT.FILL, SWT.CENTER).grab(true, false).create());
		name.addModifyListener(this);
	}

	private void createDarstellung(final Composite parent) {
		final Label label = new Label(parent, SWT.NONE);
		label.setText("Darstellung");
		label.setLayoutData(GridDataFactory.swtDefaults().align(SWT.LEFT, SWT.TOP).create());
		darstellung = new TreeViewer(parent, SWT.SINGLE | SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER);
		darstellung.getControl().setLayoutData(GridDataFactory.fillDefaults().grab(true, true).create());
		darstellung.setContentProvider(new EinstellungenContentProvider());
		darstellung.setLabelProvider(new EmfLabelProvider());
		darstellung.setInput(DarstellungenEinstellungen.INSTANCE);
		darstellung.addSelectionChangedListener(this);
	}

	private void updatePageComplete() {
		boolean complete = true;

		complete &= !name.getText().isEmpty();
		complete &= !darstellung.getSelection().isEmpty();
		complete &= ((IStructuredSelection) darstellung.getSelection()).getFirstElement() instanceof Darstellung;

		setPageComplete(complete);
	}

	/**
	 * Gibt die Ansicht zurück, wie sie auf dieser Wizard Page parametriert
	 * wurde.
	 */
	public Ansicht getAnsicht() {
		final Ansicht ansicht = DarstellungFactory.eINSTANCE.createAnsicht();
		ansicht.setName(name.getText());

		final ITreeSelection selection = (ITreeSelection) darstellung.getSelection();
		ansicht.setDarstellung((Darstellung) EcoreUtil.copy((EObject) selection.getFirstElement()));

		return ansicht;
	}

	@Override
	public void dispose() {
		name.removeModifyListener(this);
		darstellung.removeSelectionChangedListener(this);
		super.dispose();
	}

	@Override
	public void modifyText(final ModifyEvent e) {
		updatePageComplete();
	}

	@Override
	public void selectionChanged(final SelectionChangedEvent event) {
		updatePageComplete();
	}

}
