/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.gef.EditDomain;
import org.eclipse.gef.Tool;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.ui.IWorkbenchPart;

import de.bsvrz.buv.plugin.dobj.editors.DobjEditDomain;

/**
 * Basisklasse für eine Action die ein {@link Tool} in einer {@link EditDomain}
 * aktiviert.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class AbstractToolAction extends WorkbenchPartAction implements PropertyChangeListener {

	private final Tool tool;

	/**
	 * Initialisiert die Tool Action.
	 *
	 * @param part
	 *            der Workbench Part, für den die Action gilt. Dieser muss eine
	 *            {@link DobjEditDomain} als Adapter liefern.
	 * @param text
	 *            der Name der Action.
	 * @param tool
	 *            das zu aktivierende Tool.
	 */
	public AbstractToolAction(final IWorkbenchPart part, final String text, final Tool tool) {
		super(part, AS_CHECK_BOX);
		setText(text);
		this.tool = tool;

		setChecked(false);
		getEditDomain().addPropertyChangeListener(this);
	}

	@Override
	protected boolean calculateEnabled() {
		return getEditDomain() != null;
	}

	/**
	 * Gibt das zu aktivierende Tool zurück.
	 */
	public Tool getTool() {
		return tool;
	}

	@Override
	public void dispose() {
		getEditDomain().removePropertyChangeListener(this);
		super.dispose();
	}

	/**
	 * Gibt die {@link EditDomain} des Workbench Parts zurück.
	 */
	protected DobjEditDomain getEditDomain() {
		return getWorkbenchPart().getAdapter(DobjEditDomain.class);
	}

	@Override
	public void run() {
		if (isChecked()) {
			getEditDomain().setActiveTool(tool);
		} else {
			getEditDomain().setActiveTool(getEditDomain().getDefaultTool());
		}
	}

	@Override
	public void propertyChange(final PropertyChangeEvent evt) {
		final String propertyName = evt.getPropertyName();
		final Object newValue = evt.getNewValue();

		if (DobjEditDomain.PROP_ACTIVE_TOOL.equals(propertyName)) {
			setChecked(newValue == tool);
		}
	}

}
