/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.actions;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.gef.ui.actions.CopyTemplateAction;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionFactory;

import de.bsvrz.buv.plugin.dobj.model.DoModel;

/**
 * Eine EMF-erweiterte Version von {@link CopyTemplateAction}.
 *
 * <p>
 * <em>Hinweis:</em> Der Quelltext wurde kopiert damit er angepasst werden kann.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class CopyDobjAction extends WorkbenchPartAction implements ISelectionChangedListener {

	private List<DoModel> templates;

	/**
	 * Constructs a new CopyTemplateAction. You must manually add this action to
	 * the palette viewer's list of selection listeners. Otherwise, this
	 * action's enabled state won't be updated properly.
	 *
	 * @param editor
	 *            the workbench part
	 * @see org.eclipse.gef.ui.actions.EditorPartAction#EditorPartAction(IEditorPart)
	 */
	public CopyDobjAction(final IEditorPart editor) {
		super(editor);
		setId(ActionFactory.COPY.getId());
		setText(GEFMessages.CopyAction_Label);
	}

	/**
	 * Returns whether the selected EditPart is a TemplateEditPart.
	 *
	 * @return whether the selected EditPart is a TemplateEditPart
	 */
	@Override
	protected boolean calculateEnabled() {
		return templates != null && !templates.isEmpty();
	}

	/**
	 * @see org.eclipse.gef.ui.actions.EditorPartAction#dispose()
	 */
	@Override
	public void dispose() {
		templates = null;
	}

	/**
	 * Sets the default {@link Clipboard Clipboard's} contents to be the
	 * currently selected template.
	 */
	@Override
	public void run() {
		Clipboard.getDefault().setContents(new ArrayList<>(templates));
	}

	/**
	 * Sets the selected EditPart and refreshes the enabled state of this
	 * action.
	 *
	 * @see ISelectionChangedListener#selectionChanged(SelectionChangedEvent)
	 */
	@Override
	public void selectionChanged(final SelectionChangedEvent event) {
		final ISelection s = event.getSelection();
		if (!(s instanceof IStructuredSelection)) {
			return;
		}
		final IStructuredSelection selection = (IStructuredSelection) s;
		templates = null;
		final List<DoModel> result = new ArrayList<>();
		for (final Object obj : selection.toList()) {
			if (obj instanceof EditPart) {
				final Object model = ((EditPart) obj).getModel();
				if (model instanceof DoModel) {
					result.add((DoModel) model);
				}
			}
		}
		if (!result.isEmpty()) {
			templates = result;
		}
		refresh();
	}

}
