/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.actions;

import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.ui.IWorkbenchPart;

/**
 * Basisklasse für Workbench Part Actions die einen {@link GraphicalViewer}
 * benötigen.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class DobjWorkbenchPartAction extends WorkbenchPartAction {

	/**
	 * Initialisiert die Action.
	 *
	 * @param part
	 *            der Workbench Part für den die Action gilt.
	 */
	public DobjWorkbenchPartAction(final IWorkbenchPart part) {
		super(part);
	}

	/**
	 * Initialisiert die Action.
	 *
	 * @param part
	 *            der Workbench Part für den die Action gilt.
	 * @param style
	 *            der Stil der Action.
	 */
	public DobjWorkbenchPartAction(final IWorkbenchPart part, final int style) {
		super(part, style);
	}

	/**
	 * Liefert nur dann <code>true</code>, wenn {@link #getViewer()} nicht
	 * <code>null</code> zurückgibt.
	 */
	@Override
	protected boolean calculateEnabled() {
		return getViewer() != null;
	}

	/**
	 * Gibt den {@link GraphicalViewer} des Workbench Parts zurück.
	 *
	 * @return der Viewer oder <code>null</code>, wenn es keinen gibt.
	 */
	protected GraphicalViewer getViewer() {
		return getWorkbenchPart().getAdapter(GraphicalViewer.class);
	}

	/**
	 * Gibt den Zoom Manager des Viewers zurück.
	 *
	 * @return der Zoom Manager des Viewers.
	 */
	protected ZoomManager getZoomManager() {
		return (ZoomManager) getViewer().getProperty(ZoomManager.class.toString());
	}

}
