/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.actions;

import org.eclipse.ui.IWorkbenchPart;

import de.bsvrz.buv.plugin.dobj.internal.DobjMessages;
import de.bsvrz.buv.plugin.dobj.tools.EllipseSelectionTool;
import de.bsvrz.buv.plugin.dobj.util.DobjIcons;

/**
 * Action zum Aktivieren des {@link EllipseSelectionTool}.
 *
 * @author BitCtrl Systems GmbH, Thierfelder
 *
 */
public class EllipseSelectionAction extends AbstractToolAction {

	/**
	 * Initialisiert die Action.
	 *
	 * @param part
	 *            der Workbench Part fuer den die Action verwendet werden soll.
	 */
	public EllipseSelectionAction(final IWorkbenchPart part) {
		super(part, DobjMessages.EllipseSelection_Label, new EllipseSelectionTool());
		setToolTipText(DobjMessages.EllipseSelection_Tooltip);
		setId(DobjActionFactory.SELECTION_ELLIPSE.getCommandId());
		setActionDefinitionId(DobjActionFactory.SELECTION_ELLIPSE.getCommandId());
		setImageDescriptor(DobjIcons.ActionSelectionEllipse.getImageDescriptor());
	}
}
