/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.actions;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.util.DobjUtil;
import de.bsvrz.buv.plugin.dobj.util.SelectionProperties;

/**
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class SelectAllAction extends DobjWorkbenchPartAction {

	/**
	 * Initialisiert die Action.
	 *
	 * @param part
	 *            der Workbench Part in dem alle Objekte selektiert werden
	 *            sollen.
	 */
	public SelectAllAction(final IWorkbenchPart part) {
		super(part);
		setText("Alles markieren");
		setId(ActionFactory.SELECT_ALL.getCommandId());
		setActionDefinitionId(ActionFactory.SELECT_ALL.getCommandId());
	}

	@Override
	public void run() {
		final List<EditPart> selList = new ArrayList<>();
		for (final EditPart ep : DobjUtil.getAllChildren(getViewer().getContents())) {
			if (ep.isSelectable() && isValidModel(ep.getModel())) {
				selList.add(ep);
			}
		}
		getViewer().setSelection(new StructuredSelection(selList));
	}

	/**
	 * Prüft das Modellobjekt eines Edit Parts. Es ist valid, wenn es ein
	 * {@link DoModel} ist und wenn {@link SelectionProperties} vorhanden sind,
	 * muss es in der Matchingmenge enthalten sein.
	 */
	protected boolean isValidModel(final Object object) {
		final SelectionProperties selectionProperties = (SelectionProperties) getViewer()
				.getProperty(SelectionProperties.class.toString());

		if (object instanceof DoModel) {
			if (selectionProperties == null) {
				return true;
			}

			final DoModel model = (DoModel) object;
			return selectionProperties.getMatchDoTypen().contains(model.getDoTyp());
		}

		return false;
	}

}
