/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.actions;

import org.eclipse.jface.action.Action;

import de.bsvrz.buv.plugin.dobj.internal.DobjMessages;
import de.bsvrz.buv.plugin.dobj.util.DobjIcons;
import de.bsvrz.buv.plugin.dobj.util.SelectionProperties;

/**
 * Aktiviert und Deaktiviert das sofortige Selektionsfeedback. Ist die Option
 * aktiviert, dann werden die Objekte bereits während des Drag-Prozesses
 * markiert, andernfalls erst beim Loslassen der Maus.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class ToggleSelectionFeedbackAction extends Action {

	private final SelectionProperties properties;

	/**
	 * Initialisiert die Action.
	 *
	 * @param properties
	 *            die zu verwaltenden Selektionseigenschaften.
	 */
	public ToggleSelectionFeedbackAction(final SelectionProperties properties) {
		super(DobjMessages.ToggleSelectionFeedback_Label, AS_CHECK_BOX);
		this.properties = properties;

		setImageDescriptor(DobjIcons.ActionToggleSelectionFeedback.getImageDescriptor());
		setToolTipText(DobjMessages.ToggleSelectionFeedback_Tooltip);

		setId(DobjActionFactory.TOGGLE_SELECTION_FEEDBACK.getCommandId());
		setActionDefinitionId(DobjActionFactory.TOGGLE_SELECTION_FEEDBACK.getCommandId());

		setChecked(properties.isShowFeedback());
	}

	@Override
	public void run() {
		properties.setShowFeedback(!properties.isShowFeedback());
		setChecked(properties.isShowFeedback());
	}

}
