/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.actions;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchPart;

import de.bsvrz.buv.plugin.dobj.internal.DobjMessages;
import de.bsvrz.buv.plugin.dobj.requests.VerbindungslinieRequest;
import de.bsvrz.buv.plugin.dobj.util.DobjIcons;

/**
 * Action zum Ein- und Auschalten der Verbindungslinie eines verschobenen
 * Objekts zu seiner Originalposition.
 *
 * <p>
 * Der Workbench Part muss einen {@link GraphicalViewer} besitzen. An die Edit
 * Parts des Viewers wird entsprechend der Auswahl des Benutzer ein
 * {@link VerbindungslinieRequest} gesendet.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 */
public class ToggleVerbindungslinieAction extends DobjWorkbenchPartAction {

	/**
	 * Initialisiert die Action.
	 *
	 * @param part
	 *            der Workbench Part mit dem die Action arbeiten soll.
	 */
	public ToggleVerbindungslinieAction(final IWorkbenchPart part) {
		super(part, IAction.AS_CHECK_BOX);

		setText(DobjMessages.ToggleVerbindungslinie_Label);
		setToolTipText(DobjMessages.ToggleVerbindungslinie_Tooltip);
		setId(DobjActionFactory.TOGGLE_VERBINDUNGSLINIE.getCommandId());
		setActionDefinitionId(DobjActionFactory.TOGGLE_VERBINDUNGSLINIE.getCommandId());
		setImageDescriptor(DobjIcons.ActionToggleVerbindingslinie.getImageDescriptor());
		setChecked(true);
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	@Override
	public void run() {
		final GraphicalViewer viewer = getViewer();

		final Request req = new VerbindungslinieRequest(isChecked());
		final Collection reditPart = new ArrayList(viewer.getEditPartRegistry().values());

		for (final Object o : reditPart) {
			((EditPart) o).performRequest(req);
		}
	}

}
