/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator;

import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

import de.bsvrz.buv.plugin.dobj.decorator.model.DatenstatusDecorator;
import de.bsvrz.buv.plugin.dobj.editparts.DoModelEditPart;

public final class DatenstatusMediator {

	private final DoModelEditPart<?, ?> editPart;

	public DatenstatusMediator(final DoModelEditPart<?, ?> editPart) {
		this.editPart = editPart;
	}

	public void mediate() {
		mediateKeineQuelleFarbe(getDoTyp());
		mediateKeineDatenFarbe(getDoTyp());
		mediateNutzdatenFarbe(getDoTyp());
	}

	private void mediateKeineQuelleFarbe(final DatenstatusDecorator decorator) {
		final RGB rgb = decorator.getKeineQuelleFarbe();
		final Color color = getResourceManager().createColor(rgb);
		getFigure().setKeineQuelleFarbe(color);
	}

	private void mediateKeineDatenFarbe(final DatenstatusDecorator decorator) {
		final RGB rgb = decorator.getKeineDatenFarbe();
		final Color color = getResourceManager().createColor(rgb);
		getFigure().setKeineDatenFarbe(color);
	}

	private void mediateNutzdatenFarbe(final DatenstatusDecorator decorator) {
		final RGB rgb = decorator.getNutzdatenFarbe();
		final Color color = getResourceManager().createColor(rgb);
		getFigure().setNutzdatenFarbe(color);
	}

	private DatenstatusDecorator getDoTyp() {
		return (DatenstatusDecorator) editPart.getModel().getDoTyp();
	}

	private DatenstatusFigure getFigure() {
		return (DatenstatusFigure) editPart.getFigure();
	}

	private ResourceManager getResourceManager() {
		return editPart.getViewer().getResourceManager();
	}

}
