/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.dobj.decorator;

import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import com.bitctrl.lib.eclipse.emf.gef.model.GefPackage;

import de.bsvrz.buv.plugin.dobj.HotspotConverter;
import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.GroesseDecorator;
import de.bsvrz.buv.plugin.dobj.model.DoModel;

public class GroesseEditPolicy extends ResizableEditPolicy {

	@Override
	protected Command getResizeCommand(final ChangeBoundsRequest request) {
		if (!(getHost().getModel() instanceof DoModel && getHost().getModel() instanceof GroesseDecorator)) {
			return super.getResizeCommand(request);
		}

		final CompoundCommand cmd = new CompoundCommand();
		aenderePositionWennNotwendig(cmd, request);
		aendereGroesseWennNotwendig(cmd, request);
		return cmd.unwrap();
	}

	protected void aenderePositionWennNotwendig(final CompoundCommand cmd, final ChangeBoundsRequest request) {
		if (!new Point().equals(request.getMoveDelta())) {
			cmd.add(erzeugeAenderePosition(request));
		}
	}

	protected Command erzeugeAenderePosition(final ChangeBoundsRequest request) {
		final EditPart editPart = (EditPart) request.getEditParts().get(0);
		final ZoomManager zoomManager = (ZoomManager) editPart.getViewer().getProperty(ZoomManager.class.toString());
		final DoModel model = (DoModel) getHost().getModel();
		Point position = model.getLocation().getTranslated(request.getMoveDelta().getScaled(1 / zoomManager.getZoom()));
		final HotspotConverter hotspotConverter = getHotspotConverter(editPart);
		if (hotspotConverter != null) {
			position = hotspotConverter.convertViewToModel(position);
		}
		return new SetCommand(model, GefPackage.Literals.LOCATED__LOCATION, position);
	}

	protected void aendereGroesseWennNotwendig(final CompoundCommand cmd, final ChangeBoundsRequest request) {
		if (!new Dimension().equals(request.getSizeDelta())) {
			cmd.add(erzeugeAendereGroesse(request));
		}
	}

	protected Command erzeugeAendereGroesse(final ChangeBoundsRequest request) {
		final DoModel model = (DoModel) getHost().getModel();
		final EditPart editPart = (EditPart) request.getEditParts().get(0);
		final ZoomManager zoomManager = (ZoomManager) editPart.getViewer().getProperty(ZoomManager.class.toString());
		final Dimension groesse = ((GroesseDecorator) model).getGroesse()
				.getExpanded(request.getSizeDelta().getScaled(1 / zoomManager.getZoom()));
		return new SetCommand(model, DobjDecoratorPackage.Literals.GROESSE_DECORATOR__GROESSE, groesse);
	}

	/**
	 * @return null, wenn es keinen HotspotConverter gibt.
	 */
	protected HotspotConverter getHotspotConverter(final EditPart editPart) {
		HotspotConverter hotspotConverter = editPart.getAdapter(HotspotConverter.class);
		if (hotspotConverter == null) {
			hotspotConverter = Platform.getAdapterManager().getAdapter(editPart, HotspotConverter.class);
		}
		return hotspotConverter;
	}

}
