/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator;
import de.bsvrz.buv.plugin.dobj.editparts.DoModelEditPart;

/**
 * Zusammenfassender Mediator für alle Attribute des
 * {@link LinienstaerkeDecorator}s.
 *
 * @author BitCtrl Systems GmbH, ChHoesel
 */
public class LinienstaerkeZoomMediator {

	private final class LinienstaerkeMediator
			extends AbstractMediator<LinienstaerkeZoomDecorator, LinienstaerkeFigure> {

		public LinienstaerkeMediator(final DoModelEditPart<?, ?> editPart) {
			super(editPart, LinienstaerkeZoomDecorator.class,
					DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE);
		}

		@Override
		protected void mediate(final LinienstaerkeZoomDecorator decorator) {
			getFigure().setLinienstaerke(decorator.getLinienstaerke());
		}

	}

	private final LinienstaerkeZoomverhaltenMediator linienstaerkeZoomverhaltenMediator;
	private final LinienstaerkeMediator linienstaerkeMediator;
	private final LinienstaerkeMaximaleLinienstaerkeMediator linienstaerkeMaximaleLinienstaerkeMediator;
	private final LinienstaerkeMinimaleLinienstaerkeMediator linienstaerkeMinimaleLinienstaerkeMediator;
	private final LinienstaerkeMaximaleZoomstufeMediator linienstaerkeMaximaleZoomstufeMediator;
	private final LinienstaerkeMinimaleZoomstufeMediator linienstaerkeMinimaleZoomstufeMediator;

	public LinienstaerkeZoomMediator(final DoModelEditPart<?, ?> editPart) {
		linienstaerkeZoomverhaltenMediator = new LinienstaerkeZoomverhaltenMediator(editPart);
		linienstaerkeMediator = new LinienstaerkeMediator(editPart);
		linienstaerkeMaximaleLinienstaerkeMediator = new LinienstaerkeMaximaleLinienstaerkeMediator(editPart);
		linienstaerkeMinimaleLinienstaerkeMediator = new LinienstaerkeMinimaleLinienstaerkeMediator(editPart);

		linienstaerkeMaximaleZoomstufeMediator = new LinienstaerkeMaximaleZoomstufeMediator(editPart);
		linienstaerkeMinimaleZoomstufeMediator = new LinienstaerkeMinimaleZoomstufeMediator(editPart);

	}

	public void mediate() {
		linienstaerkeZoomverhaltenMediator.mediate();
		linienstaerkeMaximaleLinienstaerkeMediator.mediate();
		linienstaerkeMediator.mediate();
		linienstaerkeMinimaleLinienstaerkeMediator.mediate();
		linienstaerkeMinimaleZoomstufeMediator.mediate();
		linienstaerkeMaximaleZoomstufeMediator.mediate();
	}

}
