/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator;

import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

import de.bsvrz.buv.plugin.dobj.decorator.model.StoerfallIndikatorDecorator;
import de.bsvrz.buv.plugin.dobj.editparts.DoModelEditPart;

public final class StoerfallIndikatorMediator {

	private final DoModelEditPart<?, ?> editPart;

	public StoerfallIndikatorMediator(final DoModelEditPart<?, ?> editPart) {
		this.editPart = editPart;
	}

	public void mediate() {
		mediateStoerungFarbe(getDoTyp());
		mediateKeineAussageFarbe(getDoTyp());
		mediateFreierVerkehrFarbe(getDoTyp());
		mediateLebhafterVerkehrFarbe(getDoTyp());
		mediateDichterVerkehrFarbe(getDoTyp());
		mediateZaehfliessenderVerkehrFarbe(getDoTyp());
		mediateStockenderVerkehrFarbe(getDoTyp());
		mediateStauFarbe(getDoTyp());
	}

	private void mediateStoerungFarbe(final StoerfallIndikatorDecorator stoerfallIndikatorDecorator) {
		final RGB rgb = stoerfallIndikatorDecorator.getStoerungFarbe();
		final Color color = getResourceManager().createColor(rgb);
		getFigure().setStoerungFarbe(color);
	}

	private void mediateKeineAussageFarbe(final StoerfallIndikatorDecorator stoerfallIndikatorDecorator) {
		final RGB rgb = stoerfallIndikatorDecorator.getKeineAussageFarbe();
		final Color color = getResourceManager().createColor(rgb);
		getFigure().setKeineAussageFarbe(color);
	}

	private void mediateFreierVerkehrFarbe(final StoerfallIndikatorDecorator stoerfallIndikatorDecorator) {
		final RGB rgb = stoerfallIndikatorDecorator.getFreierVerkehrFarbe();
		final Color color = getResourceManager().createColor(rgb);
		getFigure().setFreierVerkehrFarbe(color);
	}

	private void mediateLebhafterVerkehrFarbe(final StoerfallIndikatorDecorator stoerfallIndikatorDecorator) {
		final RGB rgb = stoerfallIndikatorDecorator.getLebhafterVerkehrFarbe();
		final Color color = getResourceManager().createColor(rgb);
		getFigure().setLebhafterVerkehrFarbe(color);
	}

	private void mediateDichterVerkehrFarbe(final StoerfallIndikatorDecorator stoerfallIndikatorDecorator) {
		final RGB rgb = stoerfallIndikatorDecorator.getDichterVerkehrFarbe();
		final Color color = getResourceManager().createColor(rgb);
		getFigure().setDichterVerkehrFarbe(color);
	}

	private void mediateZaehfliessenderVerkehrFarbe(final StoerfallIndikatorDecorator stoerfallIndikatorDecorator) {
		final RGB rgb = stoerfallIndikatorDecorator.getZaehfliessenderVerkehrFarbe();
		final Color color = getResourceManager().createColor(rgb);
		getFigure().setZaehfliessenderVerkehrFarbe(color);
	}

	private void mediateStockenderVerkehrFarbe(final StoerfallIndikatorDecorator stoerfallIndikatorDecorator) {
		final RGB rgb = stoerfallIndikatorDecorator.getStockenderVerkehrFarbe();
		final Color color = getResourceManager().createColor(rgb);
		getFigure().setStockenderVerkehrFarbe(color);
	}

	private void mediateStauFarbe(final StoerfallIndikatorDecorator stoerfallIndikatorDecorator) {
		final RGB rgb = stoerfallIndikatorDecorator.getStauFarbe();
		final Color color = getResourceManager().createColor(rgb);
		getFigure().setStauFarbe(color);
	}

	private StoerfallIndikatorDecorator getDoTyp() {
		return (StoerfallIndikatorDecorator) editPart.getModel().getDoTyp();
	}

	private StoerfallIndikatorFigure getFigure() {
		return (StoerfallIndikatorFigure) editPart.getFigure();
	}

	private ResourceManager getResourceManager() {
		return editPart.getViewer().getResourceManager();
	}

}
