/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator;

import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.VordergrundfarbeDecorator;
import de.bsvrz.buv.plugin.dobj.editparts.DoModelEditPart;

public final class VordergrundfarbeMediator extends AbstractMediator<VordergrundfarbeDecorator, IFigure> {

	public VordergrundfarbeMediator(final DoModelEditPart<?, ?> editPart) {
		super(editPart, VordergrundfarbeDecorator.class,
				DobjDecoratorPackage.Literals.VORDERGRUNDFARBE_DECORATOR__VORDERGRUNDFARBE);
	}

	@Override
	protected void mediate(final VordergrundfarbeDecorator decorator) {
		final RGB rgb = decorator.getVordergrundfarbe();
		final Color color = getResourceManager().createColor(rgb);
		getFigure().setForegroundColor(color);
	}

}
