/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator.internal.properties.tabbed;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import de.bsvrz.buv.plugin.dobj.decorator.model.DatenstatusDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;

public final class DatenstatusDecoratorPropertySection
		extends ZustandsfarbenDecoratorPropertySection<DatenstatusDecorator> {

	@Override
	public void createControls(final Composite parent, final TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);

		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		final Composite container = factory.createFlatFormComposite(parent);

		Text vorgaengerText = null;
		vorgaengerText = createDatenstatusColor("Keine Quelle:",
				DobjDecoratorPackage.Literals.DATENSTATUS_DECORATOR__KEINE_QUELLE_FARBE, container, vorgaengerText);

		vorgaengerText = createDatenstatusColor("Keine Daten:",
				DobjDecoratorPackage.Literals.DATENSTATUS_DECORATOR__KEINE_DATEN_FARBE, container, vorgaengerText);

		createDatenstatusColor("Nutzdaten:", DobjDecoratorPackage.Literals.DATENSTATUS_DECORATOR__NUTZDATEN_FARBE,
				container, vorgaengerText);
	}

}
