/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator.internal.properties.tabbed;

import static org.eclipse.swt.SWT.BORDER;
import static org.eclipse.swt.SWT.CENTER;
import static org.eclipse.swt.SWT.CHECK;
import static org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants.HSPACE;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import com.bitctrl.lib.eclipse.emf.gef.commands.UnsetCommand;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.DrehungDecorator;
import de.bsvrz.buv.plugin.dobj.model.DoKomponente;
import de.bsvrz.buv.plugin.dobj.properties.AbstractSection;

public final class DrehungDecoratorPropertySection extends AbstractSection<DrehungDecorator> {

	private Label drehungLabel;
	private Spinner drehung;
	private Button drehungUseDefault;

	@Override
	public void createControls(final Composite parent, final TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);

		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		final Composite container = factory.createFlatFormComposite(parent);

		createDrehung(container);
	}

	private void createDrehung(final Composite parent) {

		// Widgets anlegen

		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		drehungLabel = factory.createLabel(parent, "Drehwinkel:");
		drehung = new Spinner(parent, BORDER);
		drehung.setMinimum(0);
		drehung.setMaximum(3600);
		drehung.setDigits(1);
		drehung.setIncrement(10);
		drehung.setPageIncrement(100);
		factory.adapt(parent);
		drehungUseDefault = factory.createButton(parent, "Defaultwert verwenden", CHECK);

		// Widgets layouten

		final FormData spinnerData = new FormData();
		spinnerData.left = new FormAttachment(drehungLabel, HSPACE);
		spinnerData.width = 150;
		spinnerData.top = new FormAttachment(0, 0);
		drehung.setLayoutData(spinnerData);
		final FormData labelData = new FormData();
		labelData.left = new FormAttachment(0, 0);
		labelData.width = STANDARD_LABEL_WIDTH;
		labelData.top = new FormAttachment(drehung, 0, CENTER);
		drehungLabel.setLayoutData(labelData);
		final FormData useDefaultData = new FormData();
		useDefaultData.left = new FormAttachment(drehung, 0, HSPACE);
		useDefaultData.top = new FormAttachment(drehung, 0, CENTER);
		drehungUseDefault.setLayoutData(useDefaultData);

		// Listener anmelden

		drehung.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				Double value = Double.valueOf(drehung.getSelection());
				value /= Math.pow(10, drehung.getDigits());
				final SetCommand cmd = new SetCommand(getElement(),
						DobjDecoratorPackage.Literals.DREHUNG_DECORATOR__DREHWINKEL, value.floatValue());
				getCommandStack().execute(cmd);
			}

		});
		drehungUseDefault.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				if (drehungUseDefault.getSelection()) {
					final UnsetCommand cmd = new UnsetCommand(getElement(),
							DobjDecoratorPackage.Literals.DREHUNG_DECORATOR__DREHWINKEL);
					getCommandStack().execute(cmd);
				} else {
					final float value = getElement().getDrehwinkel();
					final SetCommand cmd = new SetCommand(getElement(),
							DobjDecoratorPackage.Literals.DREHUNG_DECORATOR__DREHWINKEL, value);
					getCommandStack().execute(cmd);
				}
			}

		});
	}

	@Override
	public void refresh() {
		setDrehungToWidget();
		disableDrehungIfNecessary();
	}

	private void setDrehungToWidget() {
		final Double drehwinkel = getElement().getDrehwinkel() * Math.pow(10, drehung.getDigits());
		final boolean isChanged = drehung.getSelection() != drehwinkel.intValue();
		if (isChanged) {
			drehung.setSelection(drehwinkel.intValue());
		}
	}

	private void disableDrehungIfNecessary() {
		final boolean isDoKomponente = getElement().eContainer() instanceof DoKomponente;
		final boolean useDefault = !getElement().isSetDrehwinkel();

		drehungUseDefault.setSelection(useDefault);

		final boolean enabled = !isDoKomponente && !useDefault;
		drehung.setEnabled(enabled);
		drehungLabel.setEnabled(enabled);
		drehungUseDefault.setEnabled(!isDoKomponente);
	}

}
