/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator.internal.properties.tabbed;

import static org.eclipse.swt.SWT.CENTER;
import static org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants.HSPACE;
import static org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants.VMARGIN;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import com.bitctrl.lib.eclipse.emf.gef.commands.UnsetCommand;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.HintergrundfarbeDecorator;
import de.bsvrz.buv.plugin.dobj.model.DoKomponente;
import de.bsvrz.buv.plugin.dobj.properties.AbstractSection;

public final class HintergrundfarbeDecoratorPropertySection extends AbstractSection<HintergrundfarbeDecorator> {

	private Label label;
	private Text colorText;
	private Button selectColorButton;
	private Button useDefaultButton;
	private Color color;

	@Override
	public void createControls(final Composite parent, final TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);

		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		final Composite container = factory.createFlatFormComposite(parent);

		createHintergrundfarbe(container);
	}

	private void createHintergrundfarbe(final Composite parent) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();

		// Widgets anlegen
		label = factory.createLabel(parent, "Hintergrundfarbe:");
		colorText = factory.createText(parent, "", SWT.READ_ONLY);
		colorText.setEditable(false);
		colorText.setEnabled(false);
		selectColorButton = factory.createButton(parent, "Ändern", SWT.PUSH);
		useDefaultButton = factory.createButton(parent, "Defaultwert verwenden", SWT.CHECK);

		// Widgets layouten
		final FormData textData = new FormData();
		textData.left = new FormAttachment(label, HSPACE);
		textData.width = 150;
		textData.top = new FormAttachment(0, VMARGIN);
		colorText.setLayoutData(textData);
		final FormData labelData = new FormData();
		labelData.left = new FormAttachment(0, 0);
		labelData.width = STANDARD_LABEL_WIDTH;
		labelData.top = new FormAttachment(colorText, 0, CENTER);
		label.setLayoutData(labelData);
		final FormData selectColorData = new FormData();
		selectColorData.left = new FormAttachment(colorText, HSPACE);
		selectColorData.top = new FormAttachment(colorText, 0, CENTER);
		selectColorButton.setLayoutData(selectColorData);
		final FormData useDefaultData = new FormData();
		useDefaultData.left = new FormAttachment(selectColorButton, 0, HSPACE);
		useDefaultData.top = new FormAttachment(colorText, 0, CENTER);
		useDefaultButton.setLayoutData(useDefaultData);

		// Listener anmelden
		selectColorButton.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				final ColorDialog dlg = new ColorDialog(parent.getShell());
				dlg.setText("Hintergrundfarbe auswählen");
				dlg.setRGB(getElement().getHintergrundfarbe());
				final RGB rgb = dlg.open();
				if (rgb != null) {
					final SetCommand command = new SetCommand(getElement(),
							DobjDecoratorPackage.Literals.HINTERGRUNDFARBE_DECORATOR__HINTERGRUNDFARBE, rgb);
					getCommandStack().execute(command);
				}
			}

		});
		useDefaultButton.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				if (useDefaultButton.getSelection()) {
					final UnsetCommand cmd = new UnsetCommand(getElement(),
							DobjDecoratorPackage.Literals.HINTERGRUNDFARBE_DECORATOR__HINTERGRUNDFARBE);
					getCommandStack().execute(cmd);
				} else {
					final RGB value = getElement().getHintergrundfarbe();
					final SetCommand cmd = new SetCommand(getElement(),
							DobjDecoratorPackage.Literals.HINTERGRUNDFARBE_DECORATOR__HINTERGRUNDFARBE, value);
					getCommandStack().execute(cmd);
				}
			}

		});
	}

	@Override
	public void refresh() {
		disposeColor();
		setColor();
		disableVordergrundFarbeIfNecessary();
	}

	private void disposeColor() {
		if (color != null) {
			color.dispose();
		}
	}

	private void setColor() {
		final RGB rgb = getElement().getHintergrundfarbe();

		color = new Color(colorText.getDisplay(), rgb);
		colorText.setText(rgb.toString());
		colorText.setBackground(color);

		final boolean useDefault = !getElement().isSetHintergrundfarbe();
		useDefaultButton.setSelection(useDefault);

		final boolean enabled = !useDefault;
		label.setEnabled(enabled);
		selectColorButton.setEnabled(enabled);
	}

	@Override
	public void dispose() {
		disposeColor();
		super.dispose();
	}

	private void disableVordergrundFarbeIfNecessary() {
		final boolean isDoKomponente = getElement().eContainer() instanceof DoKomponente;
		final boolean useDefault = !getElement().isSetHintergrundfarbe();

		useDefaultButton.setSelection(useDefault);

		final boolean enabled = !isDoKomponente && !useDefault;
		selectColorButton.setEnabled(enabled);
		colorText.setEnabled(enabled);
		useDefaultButton.setEnabled(!isDoKomponente);
	}

}
