/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator.internal.properties.tabbed;

import static org.eclipse.swt.SWT.BORDER;
import static org.eclipse.swt.SWT.CENTER;
import static org.eclipse.swt.SWT.CHECK;
import static org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants.HSPACE;
import static org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants.VMARGIN;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import com.bitctrl.lib.eclipse.emf.gef.commands.UnsetCommand;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.Zoomverhalten;
import de.bsvrz.buv.plugin.dobj.model.DoKomponente;
import de.bsvrz.buv.plugin.dobj.properties.AbstractSection;

public final class LinienstaerkeZoomDecoratorPropertySection extends AbstractSection<LinienstaerkeZoomDecorator> {

	private final class LinienStaerkeUseDefaultSelectionAdapter extends SelectionAdapter {
		@Override
		public void widgetSelected(final SelectionEvent e) {
			if (linienstaerkeUseDefault.getSelection()) {
				final UnsetCommand cmd = new UnsetCommand(getElement(),
						DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE);
				getCommandStack().execute(cmd);
			} else {
				final int value = getElement().getLinienstaerke();
				final SetCommand cmd = new SetCommand(getElement(),
						DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE, value);
				getCommandStack().execute(cmd);
			}
		}
	}

	private final class LinienStaerkeSelectionAdapter extends SelectionAdapter {
		@Override
		public void widgetSelected(final SelectionEvent e) {
			final int value = linienstaerke.getSelection();
			final SetCommand cmd = new SetCommand(getElement(),
					DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE, value);
			getCommandStack().execute(cmd);
		}
	}

	private final class MaximalZoomstufeUseDefaultSelectionAdapter extends SelectionAdapter {
		@Override
		public void widgetSelected(final SelectionEvent e) {
			if (maximaleZoomstufeUseDefault.getSelection()) {
				final UnsetCommand cmd = new UnsetCommand(getElement(),
						DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE);
				getCommandStack().execute(cmd);
			} else {
				final int value = getElement().getLinienstaerkeMaximaleZoomstufe();
				final SetCommand cmd = new SetCommand(getElement(),
						DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE,
						value);
				getCommandStack().execute(cmd);
			}
		}
	}

	private final class MaximalLinienstaerkeUseDefaultSelectionAdapter extends SelectionAdapter {
		@Override
		public void widgetSelected(final SelectionEvent e) {
			if (maximaleLinienstaerkeUseDefault.getSelection()) {
				final UnsetCommand cmd = new UnsetCommand(getElement(),
						DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMUM);
				getCommandStack().execute(cmd);
			} else {
				final int value = getElement().getLinienstaerkeMaximum();
				final SetCommand cmd = new SetCommand(getElement(),
						DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMUM, value);
				getCommandStack().execute(cmd);
			}
		}
	}

	private final class MaximalZoomstufeSelectionAdapter extends SelectionAdapter {
		@Override
		public void widgetSelected(final SelectionEvent e) {
			final int wert = maximaleZoomstufeSpinner.getSelection();
			final SetCommand cmd = new SetCommand(getElement(),
					DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE, wert);
			getCommandStack().execute(cmd);

		}
	}

	private final class MaximalLinienstaerkeSelectionAdapter extends SelectionAdapter {
		@Override
		public void widgetSelected(final SelectionEvent e) {
			final int wert = maximaleLinienstaerkeSpinner.getSelection();
			final SetCommand cmd = new SetCommand(getElement(),
					DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MAXIMUM, wert);
			getCommandStack().execute(cmd);

		}
	}

	private final class MinimalZoomstufeUseDefaultSelectionAdapter extends SelectionAdapter {
		@Override
		public void widgetSelected(final SelectionEvent e) {
			if (minimaleZoomstufeUseDefault.getSelection()) {
				final UnsetCommand cmd = new UnsetCommand(getElement(),
						DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMALE_ZOOMSTUFE);
				getCommandStack().execute(cmd);
			} else {
				final int value = getElement().getLinienstaerkeMinimaleZoomstufe();
				final SetCommand cmd = new SetCommand(getElement(),
						DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMALE_ZOOMSTUFE,
						value);
				getCommandStack().execute(cmd);
			}
		}
	}

	private final class MinimalLinienstaerkeUseDefaultSelectionAdapter extends SelectionAdapter {
		@Override
		public void widgetSelected(final SelectionEvent e) {
			if (minimaleLinienstaerkeUseDefault.getSelection()) {
				final UnsetCommand cmd = new UnsetCommand(getElement(),
						DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMUM);
				getCommandStack().execute(cmd);
			} else {
				final int value = getElement().getLinienstaerkeMinimum();
				final SetCommand cmd = new SetCommand(getElement(),
						DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMUM, value);
				getCommandStack().execute(cmd);
			}
		}
	}

	private final class MinimalZoomstufeSelectionAdapter extends SelectionAdapter {
		@Override
		public void widgetSelected(final SelectionEvent e) {
			final int wert = minimaleZoomstufeSpinner.getSelection();
			final SetCommand cmd = new SetCommand(getElement(),
					DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMALE_ZOOMSTUFE, wert);
			getCommandStack().execute(cmd);

		}
	}

	private final class MinimalLinienStaerkeSelectionAdapter extends SelectionAdapter {
		@Override
		public void widgetSelected(final SelectionEvent e) {
			final int wert = minimaleLinienstaerkeSpinner.getSelection();
			final SetCommand cmd = new SetCommand(getElement(),
					DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_MINIMUM, wert);
			getCommandStack().execute(cmd);

		}
	}

	private Label linienstaerkeLabel;
	private Spinner linienstaerke;
	private Button linienstaerkeUseDefault;
	private Button statischesZoomverhaltenBtn;
	private Group statischesZoomverhaltenGroup;
	private Button dynamischesZoomverhaltenBtn;
	private Group dynamischesZoomverhaltenGroup;
	private Spinner minimaleZoomstufeSpinner;
	private Button minimaleZoomstufeUseDefault;
	private Spinner maximaleZoomstufeSpinner;
	private Button maximaleZoomstufeUseDefault;
	private Spinner minimaleLinienstaerkeSpinner;
	private Button minimaleLinienstaerkeUseDefault;
	private Spinner maximaleLinienstaerkeSpinner;
	private Button maximaleLinienstaerkeUseDefault;
	private Label labelMinZoomstufe;

	@Override
	public void createControls(final Composite parent, final TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);

		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		final Composite container = factory.createFlatFormComposite(parent);

		final Group group = factory.createGroup(container, "Linienstärke");
		final FormLayout layout = new FormLayout();
		layout.marginWidth = ITabbedPropertyConstants.HSPACE + 2;
		layout.marginHeight = ITabbedPropertyConstants.VSPACE;
		layout.spacing = ITabbedPropertyConstants.VMARGIN + 1;
		group.setLayout(layout);

		final FormData data = new FormData();
		data.left = new FormAttachment(0, HSPACE);
		data.right = new FormAttachment(100);
		data.top = new FormAttachment(container, 0, SWT.TOP);
		group.setLayoutData(data);

		createStatischesZoomverhalten(group);

		createDynamischesZoomverhalten(group);

	}

	private void createDynamischesZoomverhalten(final Composite container) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();

		dynamischesZoomverhaltenBtn = getWidgetFactory().createButton(container,
				Zoomverhalten.DYNAMISCHES_ZOOMVERHALTEN.getLiteral(), SWT.RADIO);

		FormData data = new FormData();
		data.left = new FormAttachment(0, HSPACE);
		data.top = new FormAttachment(statischesZoomverhaltenGroup, ITabbedPropertyConstants.VSPACE, SWT.BOTTOM);
		dynamischesZoomverhaltenBtn.setLayoutData(data);

		dynamischesZoomverhaltenGroup = getWidgetFactory().createGroup(container, "");
		final FormLayout layout = new FormLayout();
		layout.marginWidth = ITabbedPropertyConstants.HSPACE + 2;
		layout.marginHeight = ITabbedPropertyConstants.VSPACE;
		layout.spacing = ITabbedPropertyConstants.VMARGIN + 1;
		dynamischesZoomverhaltenGroup.setLayout(layout);

		data = new FormData();
		data.left = new FormAttachment(0, HSPACE);
		data.right = new FormAttachment(100);
		data.top = new FormAttachment(dynamischesZoomverhaltenBtn, 0, SWT.TOP);
		dynamischesZoomverhaltenGroup.setLayoutData(data);

		createDynamischeZoomstufen(factory);

		createDynamischeLinienstaerke(factory);

		dynamischesZoomverhaltenBtn.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				final SetCommand cmd = new SetCommand(getElement(),
						DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_ZOOMVERHALTEN,
						Zoomverhalten.DYNAMISCHES_ZOOMVERHALTEN);
				getCommandStack().execute(cmd);
			}
		});

	}

	private void createDynamischeZoomstufen(final TabbedPropertySheetWidgetFactory factory) {
		labelMinZoomstufe = factory.createLabel(dynamischesZoomverhaltenGroup, "Minimale Zoomstufe (in %):");
		FormData labelData = new FormData();
		labelData.left = new FormAttachment(0, 0);
		labelData.width = STANDARD_LABEL_WIDTH;
		labelData.top = new FormAttachment(0, VMARGIN);
		labelMinZoomstufe.setLayoutData(labelData);

		minimaleZoomstufeSpinner = new Spinner(dynamischesZoomverhaltenGroup, SWT.BORDER);
		minimaleZoomstufeSpinner.setValues(1, 1, Integer.MAX_VALUE, 0, 1, 100);
		factory.adapt(minimaleZoomstufeSpinner);
		FormData textData = new FormData();
		textData.left = new FormAttachment(labelMinZoomstufe, HSPACE);
		textData.width = 150;
		textData.top = new FormAttachment(labelMinZoomstufe, 0, CENTER);
		minimaleZoomstufeSpinner.setLayoutData(textData);
		minimaleZoomstufeSpinner.addSelectionListener(new MinimalZoomstufeSelectionAdapter());

		minimaleZoomstufeUseDefault = factory.createButton(dynamischesZoomverhaltenGroup, "default", SWT.CHECK);
		textData = new FormData();
		textData.left = new FormAttachment(minimaleZoomstufeSpinner, HSPACE);
		textData.width = 70;
		textData.top = new FormAttachment(labelMinZoomstufe, 0, CENTER);
		minimaleZoomstufeUseDefault.setLayoutData(textData);

		minimaleZoomstufeUseDefault.addSelectionListener(new MinimalZoomstufeUseDefaultSelectionAdapter());

		final Label labelMaxZoomstufe = factory.createLabel(dynamischesZoomverhaltenGroup,
				"Maximale Zoomstufe (in %):");
		labelData = new FormData();
		labelData.left = new FormAttachment(minimaleZoomstufeUseDefault, HSPACE);
		labelData.width = STANDARD_LABEL_WIDTH;
		labelData.top = new FormAttachment(0, VMARGIN);
		labelMaxZoomstufe.setLayoutData(labelData);

		maximaleZoomstufeSpinner = new Spinner(dynamischesZoomverhaltenGroup, SWT.BORDER);
		maximaleZoomstufeSpinner.setValues(5000, 0, Integer.MAX_VALUE, 0, 1, 100);
		factory.adapt(maximaleZoomstufeSpinner);
		textData = new FormData();
		textData.left = new FormAttachment(labelMaxZoomstufe, HSPACE);
		textData.width = 150;
		textData.top = new FormAttachment(maximaleZoomstufeSpinner, 0, CENTER);
		maximaleZoomstufeSpinner.setLayoutData(textData);
		maximaleZoomstufeSpinner.addSelectionListener(new MaximalZoomstufeSelectionAdapter());

		maximaleZoomstufeUseDefault = factory.createButton(dynamischesZoomverhaltenGroup, "default", SWT.CHECK);
		textData = new FormData();
		textData.left = new FormAttachment(maximaleZoomstufeSpinner, HSPACE);
		textData.width = 70;
		textData.top = new FormAttachment(labelMaxZoomstufe, 0, CENTER);
		maximaleZoomstufeUseDefault.setLayoutData(textData);
		maximaleZoomstufeUseDefault.addSelectionListener(new MaximalZoomstufeUseDefaultSelectionAdapter());
	}

	private void createDynamischeLinienstaerke(final TabbedPropertySheetWidgetFactory factory) {
		FormData labelData;
		FormData textData;
		final Label labelMinLinienstaerke = factory.createLabel(dynamischesZoomverhaltenGroup,
				"Minimale Linienstärke:");
		labelData = new FormData();
		labelData.left = new FormAttachment(0, 0);
		labelData.width = STANDARD_LABEL_WIDTH;
		labelData.top = new FormAttachment(labelMinZoomstufe, ITabbedPropertyConstants.VSPACE, SWT.BOTTOM);
		labelMinLinienstaerke.setLayoutData(labelData);

		minimaleLinienstaerkeSpinner = new Spinner(dynamischesZoomverhaltenGroup, SWT.BORDER);
		minimaleLinienstaerkeSpinner.setValues(1, 1, Integer.MAX_VALUE, 0, 1, 100);
		factory.adapt(minimaleLinienstaerkeSpinner);
		textData = new FormData();
		textData.left = new FormAttachment(labelMinLinienstaerke, HSPACE);
		textData.width = 150;
		textData.top = new FormAttachment(labelMinLinienstaerke, 0, SWT.TOP);
		minimaleLinienstaerkeSpinner.setLayoutData(textData);
		minimaleLinienstaerkeSpinner.addSelectionListener(new MinimalLinienStaerkeSelectionAdapter());

		minimaleLinienstaerkeUseDefault = factory.createButton(dynamischesZoomverhaltenGroup, "default", SWT.CHECK);
		textData = new FormData();
		textData.left = new FormAttachment(minimaleLinienstaerkeSpinner, HSPACE);
		textData.width = 70;
		textData.top = new FormAttachment(labelMinLinienstaerke, 0, CENTER);
		minimaleLinienstaerkeUseDefault.setLayoutData(textData);
		minimaleLinienstaerkeUseDefault.addSelectionListener(new MinimalLinienstaerkeUseDefaultSelectionAdapter());

		final Label labelMaxLinienstaerke = factory.createLabel(dynamischesZoomverhaltenGroup,
				"Maximale Linienstärke:");
		labelData = new FormData();
		labelData.left = new FormAttachment(minimaleLinienstaerkeUseDefault, HSPACE);
		labelData.width = STANDARD_LABEL_WIDTH;
		labelData.top = new FormAttachment(labelMinLinienstaerke, 0, CENTER);
		labelMaxLinienstaerke.setLayoutData(labelData);

		maximaleLinienstaerkeSpinner = new Spinner(dynamischesZoomverhaltenGroup, SWT.BORDER);
		maximaleLinienstaerkeSpinner.setValues(5000, 0, Integer.MAX_VALUE, 0, 1, 100);
		factory.adapt(maximaleLinienstaerkeSpinner);
		textData = new FormData();
		textData.left = new FormAttachment(labelMaxLinienstaerke, HSPACE);
		textData.width = 150;
		textData.top = new FormAttachment(labelMaxLinienstaerke, 0, CENTER);
		maximaleLinienstaerkeSpinner.setLayoutData(textData);
		maximaleLinienstaerkeSpinner.addSelectionListener(new MaximalLinienstaerkeSelectionAdapter());

		maximaleLinienstaerkeUseDefault = factory.createButton(dynamischesZoomverhaltenGroup, "default", SWT.CHECK);
		textData = new FormData();
		textData.left = new FormAttachment(maximaleLinienstaerkeSpinner, HSPACE);
		textData.width = 70;
		textData.top = new FormAttachment(labelMaxLinienstaerke, 0, CENTER);
		maximaleLinienstaerkeUseDefault.setLayoutData(textData);
		maximaleLinienstaerkeUseDefault.addSelectionListener(new MaximalLinienstaerkeUseDefaultSelectionAdapter());
	}

	private void createStatischesZoomverhalten(final Composite parent) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();

		// Widgets anlegen

		statischesZoomverhaltenBtn = getWidgetFactory().createButton(parent,
				Zoomverhalten.STATISCHES_ZOOMVERHALTEN.getLiteral(), SWT.RADIO);
		statischesZoomverhaltenBtn.setSelection(true);

		FormData data = new FormData();
		data.left = new FormAttachment(0, HSPACE);
		data.top = new FormAttachment(parent, ITabbedPropertyConstants.VSPACE, SWT.BOTTOM);
		statischesZoomverhaltenBtn.setLayoutData(data);

		statischesZoomverhaltenGroup = getWidgetFactory().createGroup(parent, "");
		final FormLayout layout = new FormLayout();
		layout.marginWidth = ITabbedPropertyConstants.HSPACE + 2;
		layout.marginHeight = ITabbedPropertyConstants.VSPACE;
		layout.spacing = ITabbedPropertyConstants.VMARGIN + 1;
		statischesZoomverhaltenGroup.setLayout(layout);

		data = new FormData();
		data.left = new FormAttachment(0, HSPACE);
		data.right = new FormAttachment(100);
		data.top = new FormAttachment(statischesZoomverhaltenBtn, 0, SWT.TOP);
		statischesZoomverhaltenGroup.setLayoutData(data);

		linienstaerkeLabel = factory.createLabel(statischesZoomverhaltenGroup, "Linienstärke:");

		linienstaerke = new Spinner(statischesZoomverhaltenGroup, BORDER);
		linienstaerke.setMinimum(1);
		linienstaerke.setMaximum(100);
		linienstaerke.setIncrement(1);
		linienstaerke.setPageIncrement(10);
		factory.adapt(parent);

		linienstaerkeUseDefault = factory.createButton(statischesZoomverhaltenGroup, "Defaultwert verwenden", CHECK);

		// Widgets layouten

		data = new FormData();
		data.left = new FormAttachment(linienstaerkeLabel, HSPACE);
		data.width = 150;
		data.top = new FormAttachment(statischesZoomverhaltenGroup, ITabbedPropertyConstants.VSPACE, SWT.TOP);
		linienstaerke.setLayoutData(data);

		final FormData labelData = new FormData();
		labelData.left = new FormAttachment(0, 0);
		labelData.width = STANDARD_LABEL_WIDTH;
		labelData.top = new FormAttachment(linienstaerke, 0, CENTER);
		linienstaerkeLabel.setLayoutData(labelData);

		final FormData useDefaultData = new FormData();
		useDefaultData.left = new FormAttachment(linienstaerke, 0, HSPACE);
		useDefaultData.top = new FormAttachment(linienstaerke, 0, CENTER);
		linienstaerkeUseDefault.setLayoutData(useDefaultData);

		// Listener anmelden

		statischesZoomverhaltenBtn.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				final SetCommand cmd = new SetCommand(getElement(),
						DobjDecoratorPackage.Literals.LINIENSTAERKE_ZOOM_DECORATOR__LINIENSTAERKE_ZOOMVERHALTEN,
						Zoomverhalten.STATISCHES_ZOOMVERHALTEN);
				getCommandStack().execute(cmd);
			}
		});

		linienstaerke.addSelectionListener(new LinienStaerkeSelectionAdapter());
		linienstaerkeUseDefault.addSelectionListener(new LinienStaerkeUseDefaultSelectionAdapter());
	}

	@Override
	public void refresh() {
		setZoomverhaltenToWidget();
		setLinienstaerkeToWidget();
		disableLinienstaerkeIfNecessary();

		if (getElement().getLinienstaerkeMinimaleZoomstufe() != minimaleZoomstufeSpinner.getSelection()) {
			minimaleZoomstufeSpinner.setSelection(getElement().getLinienstaerkeMinimaleZoomstufe());
		}

		if (getElement().getLinienstaerkeMaximaleZoomstufe() != maximaleZoomstufeSpinner.getSelection()) {
			maximaleZoomstufeSpinner.setSelection(getElement().getLinienstaerkeMaximaleZoomstufe());
		}

		if (getElement().getLinienstaerkeMinimum() != minimaleLinienstaerkeSpinner.getSelection()) {
			minimaleLinienstaerkeSpinner.setSelection(getElement().getLinienstaerkeMinimum());
		}

		if (getElement().getLinienstaerkeMaximum() != maximaleLinienstaerkeSpinner.getSelection()) {
			maximaleLinienstaerkeSpinner.setSelection(getElement().getLinienstaerkeMaximum());
		}
		disableMinMaxZoomstufeIfNecessary();
		disableMinMaxLinienstaerkeIfNecessary();
	}

	private void setZoomverhaltenToWidget() {
		final Zoomverhalten zoomverhalten = getElement().getLinienstaerkeZoomverhalten();
		final boolean isChanged = (dynamischesZoomverhaltenBtn.getSelection()
				&& zoomverhalten != Zoomverhalten.DYNAMISCHES_ZOOMVERHALTEN)
				|| (statischesZoomverhaltenBtn.getSelection()
						&& zoomverhalten != Zoomverhalten.STATISCHES_ZOOMVERHALTEN);
		if (isChanged) {
			dynamischesZoomverhaltenBtn.setSelection(zoomverhalten == Zoomverhalten.DYNAMISCHES_ZOOMVERHALTEN);
			statischesZoomverhaltenBtn.setSelection(zoomverhalten == Zoomverhalten.STATISCHES_ZOOMVERHALTEN);
		}
	}

	private void setLinienstaerkeToWidget() {
		final boolean isChanged = linienstaerke.getSelection() != getElement().getLinienstaerke();
		if (isChanged) {
			linienstaerke.setSelection(getElement().getLinienstaerke());
		}
	}

	private void disableLinienstaerkeIfNecessary() {
		final boolean isDoKomponente = getElement().eContainer() instanceof DoKomponente;
		final boolean useDefault = !getElement().isSetLinienstaerke();

		linienstaerkeUseDefault.setSelection(useDefault);

		final boolean enabled = !isDoKomponente && !useDefault;
		linienstaerke.setEnabled(enabled);
		linienstaerkeLabel.setEnabled(enabled);
		linienstaerkeUseDefault.setEnabled(!isDoKomponente);
	}

	private void disableMinMaxZoomstufeIfNecessary() {
		final boolean isDoKomponente = getElement().eContainer() instanceof DoKomponente;
		final boolean useDefaultMinimaleZoomstufe = !getElement().isSetLinienstaerkeMinimaleZoomstufe();
		final boolean useDefaultMaximaleZoomstufe = !getElement().isSetLinienstaerkeMaximaleZoomstufe();

		minimaleZoomstufeUseDefault.setSelection(useDefaultMinimaleZoomstufe);
		maximaleZoomstufeUseDefault.setSelection(useDefaultMaximaleZoomstufe);

		final boolean enabledMinimaleZoomstufe = !isDoKomponente && !useDefaultMinimaleZoomstufe;
		minimaleZoomstufeSpinner.setEnabled(enabledMinimaleZoomstufe);
		minimaleZoomstufeUseDefault.setEnabled(!isDoKomponente);

		final boolean enabledMaximaleZoomstufe = !isDoKomponente && !useDefaultMaximaleZoomstufe;
		maximaleZoomstufeSpinner.setEnabled(enabledMaximaleZoomstufe);
		maximaleZoomstufeUseDefault.setEnabled(!isDoKomponente);
	}

	private void disableMinMaxLinienstaerkeIfNecessary() {
		final boolean isDoKomponente = getElement().eContainer() instanceof DoKomponente;
		final boolean useDefaultMinimaleLinienstaerke = !getElement().isSetLinienstaerkeMinimum();
		final boolean useDefaultMaximaleLinienstaerke = !getElement().isSetLinienstaerkeMaximum();

		minimaleLinienstaerkeUseDefault.setSelection(useDefaultMinimaleLinienstaerke);
		maximaleLinienstaerkeUseDefault.setSelection(useDefaultMaximaleLinienstaerke);

		final boolean enabledMinimaleLinienstaerke = !isDoKomponente && !useDefaultMinimaleLinienstaerke;
		minimaleLinienstaerkeSpinner.setEnabled(enabledMinimaleLinienstaerke);
		minimaleLinienstaerkeUseDefault.setEnabled(!isDoKomponente);

		final boolean enabledMaximaleLinienstaerke = !isDoKomponente && !useDefaultMaximaleLinienstaerke;
		maximaleLinienstaerkeSpinner.setEnabled(enabledMaximaleLinienstaerke);
		maximaleLinienstaerkeUseDefault.setEnabled(!isDoKomponente);
	}

}
