/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator.internal.properties.tabbed;

import static org.eclipse.swt.SWT.CENTER;
import static org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants.HSPACE;
import static org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants.VMARGIN;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import com.bitctrl.lib.eclipse.emf.gef.commands.UnsetCommand;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.SchriftDecorator;
import de.bsvrz.buv.plugin.dobj.properties.AbstractSection;

/**
 * PropertySection für {@link SchriftDecorator}.
 *
 * @author BitCtrl Systems GmbH, Ch. Hösel
 *
 */
public final class SchriftDecoratorPropertySection extends AbstractSection<SchriftDecorator> {

	private Label label;
	private Text fontText;
	private Button selectFontButton;
	private Button useDefaultButton;
	private Font font;

	@Override
	public void createControls(final Composite parent, final TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);

		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		final Composite container = factory.createFlatFormComposite(parent);

		createSchrift(container);
	}

	private void createSchrift(final Composite parent) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();

		// Widgets anlegen
		label = factory.createLabel(parent, "Schrift:");
		fontText = factory.createText(parent, "", SWT.READ_ONLY);
		fontText.setEditable(false);
		fontText.setEnabled(false);
		selectFontButton = factory.createButton(parent, "Ändern", SWT.PUSH);
		useDefaultButton = factory.createButton(parent, "Defaultwert verwenden", SWT.CHECK);

		// Widgets layouten
		final FormData textData = new FormData();
		textData.left = new FormAttachment(label, HSPACE);
		textData.width = 150;
		textData.top = new FormAttachment(0, VMARGIN);
		fontText.setLayoutData(textData);
		final FormData labelData = new FormData();
		labelData.left = new FormAttachment(0, 0);
		labelData.width = STANDARD_LABEL_WIDTH;
		labelData.top = new FormAttachment(fontText, 0, CENTER);
		label.setLayoutData(labelData);
		final FormData selectColorData = new FormData();
		selectColorData.left = new FormAttachment(fontText, HSPACE);
		selectColorData.top = new FormAttachment(fontText, 0, CENTER);
		selectFontButton.setLayoutData(selectColorData);
		final FormData useDefaultData = new FormData();
		useDefaultData.left = new FormAttachment(selectFontButton, 0, HSPACE);
		useDefaultData.top = new FormAttachment(fontText, 0, CENTER);
		useDefaultButton.setLayoutData(useDefaultData);

		// Listener anmelden
		selectFontButton.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				final FontDialog dlg = new FontDialog(parent.getShell());
				dlg.setText("Vordergrundfarbe auswählen");
				if (getElement().isSetSchrift()) {
					dlg.setFontList(new FontData[] { getElement().getSchrift() });
				}
				final FontData fontData = dlg.open();
				if (fontData != null) {
					final SetCommand command = new SetCommand(getElement(),
							DobjDecoratorPackage.Literals.SCHRIFT_DECORATOR__SCHRIFT, fontData);
					getCommandStack().execute(command);
				}
			}

		});
		useDefaultButton.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				if (useDefaultButton.getSelection()) {
					final UnsetCommand cmd = new UnsetCommand(getElement(),
							DobjDecoratorPackage.Literals.SCHRIFT_DECORATOR__SCHRIFT);
					getCommandStack().execute(cmd);
				} else {
					final FontData value = new FontData();
					final SetCommand cmd = new SetCommand(getElement(),
							DobjDecoratorPackage.Literals.SCHRIFT_DECORATOR__SCHRIFT, value);
					getCommandStack().execute(cmd);
				}
			}

		});
	}

	@Override
	public void refresh() {
		disposeFont();
		setFont();
	}

	private void disposeFont() {
		if (font != null) {
			font.dispose();
		}
	}

	private void setFont() {
		if (getElement().isSetSchrift()) {
			final FontData fontData = getElement().getSchrift();
			font = new Font(fontText.getDisplay(), fontData);
			fontText.setText(fontData.toString());
		} else {
			font = null;
			fontText.setText("Defaultschrift");
		}

		fontText.setFont(font);

		final boolean useDefault = !getElement().isSetSchrift();
		useDefaultButton.setSelection(useDefault);

		final boolean enabled = !useDefault;
		label.setEnabled(enabled);
		selectFontButton.setEnabled(enabled);
	}

	@Override
	public void dispose() {
		disposeFont();
		super.dispose();
	}

}
