/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator.internal.properties.tabbed;

import static org.eclipse.swt.SWT.CENTER;
import static org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants.HSPACE;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.SelektierbarDecorator;
import de.bsvrz.buv.plugin.dobj.properties.AbstractSection;

/**
 * PropertySection zum Einstellen der "selektierbar" Property an einem DO.
 *
 * @author BitCtrl Systems GmbH, Ch. Hösel
 *
 */
public class SelektierbarPropertySection extends AbstractSection<SelektierbarDecorator> {

	private Label selektierbarLabel;
	private Button btnSelektierbar;

	@Override
	public void createControls(final Composite parent, final TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);

		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		final Composite container = factory.createFlatFormComposite(parent);

		createSkalierung(container);
	}

	private void createSkalierung(final Composite parent) {

		// Widgets anlegen

		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		selektierbarLabel = factory.createLabel(parent, "Selektierbar:");
		btnSelektierbar = new Button(parent, SWT.CHECK);
		btnSelektierbar.setText("");

		factory.adapt(parent);

		// Widgets layouten

		final FormData spinnerData = new FormData();
		spinnerData.left = new FormAttachment(selektierbarLabel, HSPACE);
		spinnerData.top = new FormAttachment(0, 0);
		btnSelektierbar.setLayoutData(spinnerData);
		final FormData labelData = new FormData();
		labelData.left = new FormAttachment(0, 0);
		labelData.width = STANDARD_LABEL_WIDTH;
		labelData.top = new FormAttachment(btnSelektierbar, 0, CENTER);
		selektierbarLabel.setLayoutData(labelData);

		// Listener anmelden

		btnSelektierbar.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				final boolean value = btnSelektierbar.getSelection();
				final SetCommand cmd = new SetCommand(getElement(),
						DobjDecoratorPackage.Literals.SELEKTIERBAR_DECORATOR__SELEKTIERBAR, value);
				getCommandStack().execute(cmd);
			}

		});
	}

	@Override
	public void refresh() {
		setSelektierbarToWidget();
	}

	private void setSelektierbarToWidget() {
		final boolean selektierbar = getElement().isSelektierbar();
		final boolean isChanged = btnSelektierbar.getSelection() != selektierbar;
		if (isChanged) {
			btnSelektierbar.setSelection(selektierbar);
		}
	}

}
