/*
 * Rahmenwerk-Plug-in "Darstellungsobjekte"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dobj.decorator.internal.properties.tabbed;

import static org.eclipse.swt.SWT.BORDER;
import static org.eclipse.swt.SWT.CENTER;
import static org.eclipse.swt.SWT.CHECK;
import static org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants.HSPACE;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import com.bitctrl.lib.eclipse.emf.gef.commands.UnsetCommand;

import de.bsvrz.buv.plugin.dobj.decorator.model.DobjDecoratorPackage;
import de.bsvrz.buv.plugin.dobj.decorator.model.SkalierungDecorator;
import de.bsvrz.buv.plugin.dobj.model.DoKomponente;
import de.bsvrz.buv.plugin.dobj.properties.AbstractSection;

public final class SkalierungDecoratorPropertySection extends AbstractSection<SkalierungDecorator> {

	private Label skalierungLabel;
	private Spinner skalierung;
	private Button skalierungUseDefault;

	@Override
	public void createControls(final Composite parent, final TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);

		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		final Composite container = factory.createFlatFormComposite(parent);

		createSkalierung(container);
	}

	private void createSkalierung(final Composite parent) {

		// Widgets anlegen

		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		skalierungLabel = factory.createLabel(parent, "Skalierung:");
		skalierung = new Spinner(parent, BORDER);
		skalierung.setMinimum(1);
		skalierung.setMaximum(Integer.MAX_VALUE);
		skalierung.setDigits(3);
		skalierung.setIncrement(100);
		skalierung.setPageIncrement(1000);
		factory.adapt(parent);
		skalierungUseDefault = factory.createButton(parent, "Defaultwert verwenden", CHECK);

		// Widgets layouten

		final FormData spinnerData = new FormData();
		spinnerData.left = new FormAttachment(skalierungLabel, HSPACE);
		spinnerData.width = 150;
		spinnerData.top = new FormAttachment(0, 0);
		skalierung.setLayoutData(spinnerData);
		final FormData labelData = new FormData();
		labelData.left = new FormAttachment(0, 0);
		labelData.width = STANDARD_LABEL_WIDTH;
		labelData.top = new FormAttachment(skalierung, 0, CENTER);
		skalierungLabel.setLayoutData(labelData);
		final FormData useDefaultData = new FormData();
		useDefaultData.left = new FormAttachment(skalierung, 0, HSPACE);
		useDefaultData.top = new FormAttachment(skalierung, 0, CENTER);
		skalierungUseDefault.setLayoutData(useDefaultData);

		// Listener anmelden

		skalierung.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				double value = skalierung.getSelection();
				value /= Math.pow(10, skalierung.getDigits());
				final SetCommand cmd = new SetCommand(getElement(),
						DobjDecoratorPackage.Literals.SKALIERUNG_DECORATOR__SKALIERUNGSFAKTOR, value);
				getCommandStack().execute(cmd);
			}

		});
		skalierungUseDefault.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				if (skalierungUseDefault.getSelection()) {
					final UnsetCommand cmd = new UnsetCommand(getElement(),
							DobjDecoratorPackage.Literals.SKALIERUNG_DECORATOR__SKALIERUNGSFAKTOR);
					getCommandStack().execute(cmd);
				} else {
					final double value = getElement().getSkalierungsfaktor();
					final SetCommand cmd = new SetCommand(getElement(),
							DobjDecoratorPackage.Literals.SKALIERUNG_DECORATOR__SKALIERUNGSFAKTOR, value);
					getCommandStack().execute(cmd);
				}
			}

		});
	}

	@Override
	public void refresh() {
		setSkalierungsfaktorToWidget();
		disableSkalierungsfaktorIfNecessary();
	}

	private void setSkalierungsfaktorToWidget() {
		final Double skalierungsfaktor = getElement().getSkalierungsfaktor() * Math.pow(10, skalierung.getDigits());
		final boolean isChanged = skalierung.getSelection() != skalierungsfaktor.intValue();
		if (isChanged) {
			skalierung.setSelection(skalierungsfaktor.intValue());
		}
	}

	private void disableSkalierungsfaktorIfNecessary() {
		final boolean isDoKomponente = getElement().eContainer() instanceof DoKomponente;
		final boolean useDefault = !getElement().isSetSkalierungsfaktor();

		skalierungUseDefault.setSelection(useDefault);

		final boolean enabled = !isDoKomponente && !useDefault;
		skalierung.setEnabled(enabled);
		skalierungLabel.setEnabled(enabled);
		skalierungUseDefault.setEnabled(!isDoKomponente);
	}

}
